<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDriverSqlsrv.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB饹SQLServer for Native Client
 *
 * http://blogs.msdn.com/sqlphp/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDriverSqlsrv.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBDriverSqlsrv extends SyL_DB
{
    /**
     * DBС󥳡
     * 
     * @access protected
     * @var string
     */
    var $server_encode = 'sjis-win';

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        if (!$host) $host = 'localhost';
        if ($port)  $host = "{$host},{$port}";
        $conn_info = array();
        $conn_info['UID'] = $user;
        if ($passwd !== null) {
            $conn_info['PWD'] = $passwd;
        }
        $conn_info['Database'] = $dbname;
        $conn_info['ConnectionPooling'] = (bool)$persistent;
        $conn_info['APP'] = 'SyL DB Driver(SQLSRV)';

        $this->connection = sqlsrv_connect($host, $conn_info);
        return is_resource($this->connection);
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection()
    {
        if (is_resource($this->connection)) {
            sqlsrv_close($this->connection);
            $this->connection = null;
        }
    }

    /**
     * Ǹ˵ä顼å򥻥å
     *
     * @access public
     * @param string 顼
     * @param string 顼å
     */
    function setErrorMessage($code='', $message='')
    {
        if ($code) {
            parent::setErrorMessage($code, $message);
        } else {
            $messages = sqlsrv_errors();
            if ($messages && isset($messages[0])) {
                $this->last_error_code    = $messages[0]['code'];
                $this->last_error_message = 'SQLSTATE: ' . $messages[0]['SQLSTATE'] . ' ' . $messages[0]['message'];
            }
        }
    }

    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function escape($parameter)
    {
        return str_replace("'", "''", $parameter);
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function beginTransaction()
    {
        parent::beginTransaction();
        sqlsrv_begin_transaction($this->connection);
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollBack()
    {
        sqlsrv_rollback($this->connection);
        parent::rollBack();
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
        sqlsrv_commit($this->connection);
        parent::commit();
    }

    /**
     * SQL¹Ԥ̼
     * 
     * SQLʸselectξ
     *   ¹Է̤꥽ȤƼ
     * SQLʸinsert, update, deleteξ
     *   ¹Է̱ƶ
     * SQLʸ嵭ʳξ
     *   ¹Ը塢true or falseֵ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed ¹Է̷ޤDB꥽
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execRef($sql, &$result)
    {
        $this->convertEncoding($sql);
        parent::execRef($sql, $result);
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function execSelect($sql)
    {
        $result = sqlsrv_query($this->connection, $sql);
        if ($result !== false) {
            return $result;
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function execUpdate($sql)
    {
        $result = sqlsrv_query($this->connection, $sql);
        if ($result !== false) {
            return sqlsrv_rows_affected($result);
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execNoReturn($sql)
    {
        $result = sqlsrv_query($this->connection, $sql);
        if ($result !== false) {
            return true;
        } else {
            $this->setErrorMessage();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function queryRef($sql, &$data, $get='all')
    {
        // SQL¹
        $this->execRef($sql, $query);

        // Ƚ
        if (!is_resource($query)) {
            $data = $query;
            return ($query !== false);
        }

        switch ($get) {
        case 'one':
            if (sqlsrv_fetch($query) !== false) {
                $data = sqlsrv_get_field($query, 0);
            } else {
                $data = '';
            }
            break;
        case 'record':
            $data = sqlsrv_fetch_array($query, SQLSRV_FETCH_ASSOC);
            if ($data !== false) {
                $data = $this->caseFieldName($data);
            } else {
                $data = array();
            }
            break;
        case 'all':
            $data = array();
            while ($result = sqlsrv_fetch_array($query, SQLSRV_FETCH_ASSOC)) {
                $data[] = $this->caseFieldName($result);
            }
            break;
        }
        sqlsrv_free_stmt($query);

        $this->convertDecoding($data);
        return true;
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function queryPageRef($sql, &$result, &$pager, $limit=20, $page=1)
    {
        if (preg_match('/^select\s+(.+)order\s+by(.+)$/i', $sql, $matches)) {
            // ڡ󥰥֥
            $pager = $this->getPager($limit, $page);
            // SQL
            $sql_count = "SELECT COUNT(*) FROM (SELECT " . $matches[1] . ") AS SyL$";
            // SQL¹
            if (!$this->queryRef($sql_count, $record, 'one')) return false;
            $pager->setCountAll($record);

            // ڡñ̥쥳ɼ
            $sql_page = trim($sql);

            $sort_asc  = $matches[2];
            $sort_desc = '';
            foreach (array_map('trim', explode(',', $sort_asc)) as $column) {
                $column = explode(' ', $column);
                $sort = 'DESC';
                $i = 1;
                while (isset($column[$i])) {
                    switch (strtoupper($column[$i])) {
                    case 'ASC':  $sort = 'DESC'; break 2;
                    case 'DESC': $sort = 'ASC';  break 2;
                    }
                    $i++;
                }
                if ($sort_desc != '') {
                    $sort_desc .= ', ';
                }
                $sort_desc .= $column[0] . ' ' . $sort;
            }

            $num = 0;
            if ($pager->getCurrentPage() >= $pager->getTotalPage()) {
                $num = $pager->getCountAll() % $pager->getCount();
            } else {
                $num = $pager->getCount();
            }

            $sql_page  = "";
            $sql_page .= "SELECT * FROM (";
            $sql_page .=   "SELECT TOP " . $num . " * FROM (";
            $sql_page .=     "SELECT TOP " . ($pager->getCount() + $pager->getStartOffset()) . " ";
            $sql_page .=     $matches[1] . ' ORDER BY ' . $sort_asc;
            $sql_page .=   ") AS SyL1$ ";
            $sql_page .=   "ORDER BY ";
            $sql_page .=     $sort_desc;
            $sql_page .= ") AS SyL2$ ";
            $sql_page .= "ORDER BY ";
            $sql_page .=   $sort_asc;
        } else {
            trigger_error("[SyL error] Sqlsrv SQL invalid [require `order by'] ({$sql_page})", E_USER_ERROR);
        }

        // ǡSQL¹
        return $this->queryRef($sql_page, $result, 'all');
    }

    /**
     * ³ƤDBСΥС
     * 
     * @access public
     * @return string DBΥС
     */
    function getVersion()
    {
        $sql = "SELECT @@VERSION";
        $this->queryRef($sql, $version, 'one');
        return $version;
    }
}

?>
