<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDao.php,v 1.10 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * SQL饹
 */
require_once 'SyL_DBSqlTableConditions.php';
/**
 * SQLϢ饹
 */
require_once 'SyL_DBSqlTableRelations.php';

/**
 * DBѥǡ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDao.php,v 1.10 2008/01/15 09:19:04 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBDao
{
    /**
     * DB֥
     *
     * @access protected
     * @var object
     */
    var $conn = null;
    /**
     * ޥ֥Ȥ
     *
     * @access protected
     * @var array
     */
    var $tables = array();
    /**
     * ڡ
     *
     * @access protected
     * @var int
     */
    var $page = 0;
    /**
     * ڡ
     *
     * @access protected
     * @var int
     */
    var $limit = 10;
    /**
     * ڡ饹
     *
     * @access protected
     * @var object
     */
    var $pager = null;
    /**
     * SELECT
     *
     * @access private
     * @var array
     */
    var $select_headers = array();
    /**
     * ORDER BY
     *
     * @access private
     * @var array
     */
    var $sort_columns = array();
    /**
     * Ϣ³DML˥顼ȯ硢
     * ߤե饰
     *
     * @access protected
     * @var bool
     */
    var $error_stop = true;
    /**
     * 顼å
     *
     * @access protected
     * @var array
     */
    var $error_messages = array();

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object DB֥
     */
    function SyL_DBDao(&$conn)
    {
        $this->conn =& $conn;
    }

    /**
     * ơ֥索֥Ⱥ
     *
     * @access public
     * @return object 索֥
     */
    function createCondition()
    {
        return new SyL_DBSqlTableConditions();
    }

    /**
     * ơ֥Ϣ֥Ⱥ
     *
     * @access public
     * @return object Ϣ֥
     */
    function createRelation()
    {
        return new SyL_DBSqlTableRelations();
    }

    /**
     * SELECTܤ
     *
     * @access public
     * @return array SELECT
     */
    function getSelectHeaders()
    {
        return $this->select_headers;
    }

    /**
     * ȹܤ
     *
     * @access public
     * @return array ȹ
     */
    function getSortColumns()
    {
        return $this->sort_columns;
    }

    /**
     * ڡɽѥ᡼򥻥å
     *
     * @access public
     * @param int ɽڡ
     * @param int 1ڡη
     */
    function setPage($page=1, $limit=20)
    {
        $this->page  = $page;
        $this->limit = $limit;
    }

    /**
     * ڡ֥Ȥ
     *
     * @access public
     * @return object ڡ֥
     */
    function &getPager()
    {
        return $this->pager;
    }

    /**
     * DBǡ
     *
     * @access public
     * @param object or array ơ֥륪֥ 
     * @param object Ϣ֥
     * @return array ǡ
     */
    function select($table, $relation=null)
    {
        // ѤѴ
        $table = $this->arrangeTables($table);

        $selects   = array();
        $froms     = array();
        $wheres    = array();
        $group_bys = array();
        $order_bys = array();
        $this->select_headers = array();
        foreach(array_keys($table) as $name) {
            $selects    = array_merge($selects, $table[$name]->getSelectColumns($this->conn));
            $froms      = array_merge($froms, (array)$table[$name]->getSelectName());
            $conditions = $table[$name]->getConditions();
            if ($conditions) {
                $where = $conditions->getWhere($this->conn);
                if ($where) {
                    $wheres[] = $where;
                }
            }
            $group_bys  = array_merge($group_bys, $table[$name]->getGroups());
            $order_bys  = array_merge($order_bys, $table[$name]->getSorts());
            // SELECTݻ
            $this->select_headers = array_merge($this->select_headers, $table[$name]->getSelectHeaders());
        }

        // Ϣ糧å
        $from = '';
        if (is_object($relation)) {
            $join = $relation->getJoin($this->conn);
            if ($join) {
                $from = $join;
            }
        }
        if (!$from) {
            $from = implode(', ', $froms);
        }
        $where    = implode(' AND ', $wheres);
        $group_by = implode(', ', $group_bys);
        $order_by = implode(', ', $order_bys);
        // ȥȥݻ
        $this->sort_columns = str_replace(' ', '.', $order_bys);

        $sql  = "";
        $sql .= "SELECT ";
        if (count($selects) > 0) {
        $sql .=   implode(', ', $selects) . " ";
        } else {
        $sql .=   "* ";
        }
        $sql .= "FROM ";
        $sql .=   $from . " ";
        if ($where) {
        $sql .= "WHERE ";
        $sql .=   $where . " ";
        }
        if ($group_by) {
        $sql .= "GROUP BY ";
        $sql .=   $group_by . " ";
        }
        if ($order_by) {
        $sql .= "ORDER BY ";
        $sql .=   $order_by . " ";
        }

//echo $sql;
//exit;

        if ($this->page === 0) {
            // ̾
            return $this->conn->query($sql);
        } else {
            // ڡ󥰤
            $this->conn->queryPageRef($sql, $result, $this->pager, $this->limit, $this->page);
            return $result;
        }
    }

    /**
     * DBϿ
     *
     * @access public
     * @param mixed ơ֥륪֥
     * @return bool true: OK, false: 顼
     */
    function insert($table)
    {
        // ѤѴ
        $table = $this->arrangeTables($table);
        // INSERT¹
        return $this->exec($table, 'insert');
    }

    /**
     * DB򹹿
     *
     * @access public
     * @param mixed ơ֥륪֥
     * @return bool true: OK, false: 顼
     */
    function update($table)
    {
        // ѤѴ
        $table = $this->arrangeTables($table);
        // UPDATE¹
        return $this->exec($table, 'update');
    }

    /**
     * DB
     *
     * @access public
     * @param mixed ơ֥륪֥
     * @return bool true: OK, false: 顼
     */
    function delete($table)
    {
        // ѤѴ
        $table = $this->arrangeTables($table);
        // DELETE¹
        return $this->exec($table, 'delete');
    }

    /**
     * ơ֥륪֥Ȥѥ᡼ѤѴ
     *
     * @access private
     * @param mixed ơ֥륪֥
     * @param string ơ֥Υꥢ̾
     */
    function arrangeTables($table)
    {
        $result = array();
        // ơ֥륪֥Ȥξ
        if (is_object($table)) {
            $alias = $table->getAliasName();
            $result[$alias] = $table;
        } else if (is_array($table)) {
            foreach ($table as $tmp) {
                $result += $this->arrangeTables($tmp);
            }
        }
        return $result;
    }

    /**
     * DBϿѤ˥
     *
     * @access private
     * @param array ơ֥륪֥
     * @param string insert or update or delete
     * @return bool true: OKfalse: 顼
     */
    function exec($table, $action)
    {
        $result = true;
        foreach (array_keys($table) as $name) {
            $conditions = $table[$name]->getConditions(false);
            $where      = ($conditions) ? $conditions->getWhere($this->conn) : '';
            if (!$this->conn->execPerform($table[$name]->getName(), $table[$name]->getDataColumns(), $action, $where)) {
                $result = false;
                $this->error_messages[] = $this->conn->errorInfo();
                if ($this->error_stop) {
                    break;
                }
            }
        }
        return $result;
    }

    /**
     * ơ֥쥳ɾ
     *
     * @access public
     * @param object ơ֥륪֥
     * @param array ѥ᡼
     * @return array ơ֥쥳ɾ
     */
    function getRecord(&$table, $parameters)
    {
        $condition = $this->createCondition();
        foreach ($parameters as $name => $value) {
            $condition->addEqual($name, $value);
        }
        $table->setConditions($condition);
        $result = $this->select($table);
        return (count($result) > 0) ? $result[0] : array();
    }

    /**
     * ơ֥
     *
     * @access public
     * @param object ơ֥륪֥
     * @param array ѥ᡼
     * @param array ȥѥ᡼
     * @return array ơ֥
     */
    function getRecords(&$table, $parameters=array(), $sorts=array())
    {
        if (count($parameters) > 0) {
            $condition = $this->createCondition();
            foreach ($parameters as $name => $value) {
                $condition->addEqual($name, $value);
            }
            $table->setConditions($condition);
        }
        foreach ($sorts as $name) {
            $table->addSort($name);
        }
        return $this->select($table);
    }

    /**
     * ơ֥MAX ID
     *
     * @access public
     * @param object ơ֥륪֥
     * @param string MAX ID
     * @param array ѥ᡼
     * @return int MAX ID
     */
    function getMaxId(&$table, $column, $parameters=array())
    {
        if (count($parameters) > 0) {
            $condition = $this->createCondition();
            foreach ($parameters as $name => $value) {
                $condition->addEqual($name, $value);
            }
            $table->setConditions($condition);
        }
        $table->addColumn($column, 'MAXID', array('MAX'));
        $result = $this->select($table);
        return (count($result) > 0) ? $result[0]['MAXID'] : null;
    }

    /**
     * 祭¸ߥå
     *
     * @access public
     * @param object ơ֥륪֥
     * @param array 祭ǡ
     * @return bool true: 祭¸ߤ, false: 祭¸ߤʤ
     */
    function hasPrimary($table, $datas)
    {
        // 索֥Ⱥ
        $conditions = $this->createCondition();
        foreach ($table->getPrimary(false) as $tmp) {
            if (isset($datas[$tmp])) {
                $conditions->addEqual($tmp, $datas[$tmp]);
            }
        }
        if (count($conditions->gets()) == 0) {
            // 祭Ĥʤ
            return false;
        }
        // Ȳ
        $table_tmp = version_compare(PHP_VERSION, '5.0.0', '>=')
                   ? unserialize(serialize($table))
                   : $table;
        // 索֥ȥå
        $table_tmp->setConditions($conditions);
        // 祭¸Ƚ
        return (count($this->select($table_tmp)) > 0);
    }

    /**
     * ե¸ߥå
     *
     * @access public
     * @param object ơ֥륪֥
     * @param array եǡ
     * @return bool true: ե¸ߤ, false: ե¸ߤʤ
     */
    function hasUnique($table, $datas)
    {
        foreach ($table->getUniques(false) as $uniques) {
            // 索֥Ⱥ
            $conditions = $this->createCondition();
            foreach ($uniques as $unique) {
                if (isset($datas[$unique])) {
                    if ($datas[$unique] !== '') {
                        $conditions->addEqual($unique, $datas[$unique]);
                    } else {
                        //  = null ϡå
                        continue 2;
                    }
                }
            }
            if (count($conditions->gets()) > 0) {
                // Ȳ
                $table_tmp = version_compare(PHP_VERSION, '5.0.0', '>=')
                           ? unserialize(serialize($table))
                           : $table;
                // ե¸ߤ
                $table_tmp->setConditions($conditions);
                // ե¸Ƚ
                if (count($this->select($table_tmp)) > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * ¸ߥå
     *
     * @access public
     * @param object ơ֥륪֥
     * @param array ǡ
     * @param string оݥơ֥̾
     * @return bool true: ¸ߤ, false: ¸ߤʤ
     */
    function hasForeign($table, $datas, &$ftabble)
    {
        foreach ($table->getForeigns(false) as $ftabble => $foreigns) {
            // 索֥Ⱥ
            $conditions = $this->createCondition();
            foreach ($foreigns as $column1 => $column2) {
                if (isset($datas[$column1])) {
                    if ($datas[$column1] !== '') {
                        $conditions->addEqual($column2, $datas[$column1]);
                    } else {
                        //  = null ϡå
                        continue 2;
                    }
                }
            }

            if (count($conditions->gets()) > 0) {
                // ¸ߤ
                $table_tmp = new SyL_DBDaoTable($ftabble);
                $table_tmp->setConditions($conditions);
                // ¸Ƚ
                if (count($this->select($table_tmp)) > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * 顼Ƚꤹ
     *
     * @access public
     * @return bool true: 顼, false: 顼ʤ
     */
    function isError()
    {
        return (count($this->error_messages) > 0);
    }

    /**
     * 顼åƼ
     *
     * @access public
     * @return array 顼å
     */
    function getErrors()
    {
        return $this->error_messages;
    }

    /**
     * ޼֥Ȥ
     *
     * @access public
     * @return object ޼֥
     */
    function &getSchema()
    {
        return $this->conn->getSchema();
    }

    /**
     * ³֥Ȥ
     *
     * @access public
     * @return object ³֥
     */
    function &getConnection()
    {
        return $this->conn;
    }
}

?>
