<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FileReader.php,v 1.3 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * եɤ߹ߥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FileReader.php,v 1.3 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FileReader extends SyL_File
{
    /**
     * ե륪ץ⡼
     * 
     * @access protected
     * @var string
     */
    var $mode = 'rb';
    /**
     * CSVСѰǥ쥯ȥ
     * 
     * @access private
     * @var string
     */
    var $tmp_dir = '/tmp';
    /**
     * CSVСѰ켡ե̾
     * 
     * @access private
     * @var string
     */
    var $tmp_name = '';

    /**
     * ǥ쥯ȥ򥻥åȤ
     *
     * @access public
     * @param string ǥ쥯ȥ
     */
    function setTmpDir($tmp_dir)
    {
        $this->tmp_dir = $tmp_dir;
    }

    /**
     * ե򳫤
     *
     * @access public
     * @param string ץ⡼
     */
    function open()
    {
        if ($this->csv && $this->encode_file) {
            $encode_script = $this->encode_script ? $this->encode_script : mb_internal_encoding();
            if (strtolower($this->encode_file) != strtolower($encode_script)) {
                $data = file_get_contents($this->resource_name);
                $data = mb_convert_encoding($data, $encode_script, $this->encode_file);

                $this->tmp_name = tempnam($this->tmp_dir, '__syl_file_');
                $writer =& SyL_File::factory('w', $this->tmp_name);
                $writer->process($data);

                $this->resource_name = $this->tmp_name;
                $this->encode_file   = $encode_script;
            }
        }
        parent::open();
    }

    /**
     * ե뤫ɤ߹
     *
     * @access public
     * @return string ϥǡ or bool(false) ɤ߹߽λ
     */
    function read()
    {
        if ($this->csv) {
            if ($this->csv_enclosure) {
                $data = fgetcsv($this->fp, 8192, $this->csv_delimiter, $this->csv_enclosure);
            } else {
                $data = fgetcsv($this->fp, 8192, $this->csv_delimiter);
            }
            return is_array($data) ? array_map(array(&$this, 'convertEncode'), $data) : $data;
        } else {
            $data = fgets($this->fp);
            return is_string($data) ? $this->convertEncode($data) : $data;
        }
    }

    /**
     * եĤ
     *
     * @access public
     */
    function close()
    {
        parent::close();

        // CSVѰե
        if (file_exists($this->tmp_name)) {
            unlink($this->tmp_name);
        }
    }

    /**
     * ϥ󥳡ǥ󥰤Ѵ
     *
     * @access private
     * @param string 󥳡ǥѴΥեΥǡ
     * @return string 󥳡ǥѴΥեΥǡ
     */
    function convertEncode($data)
    {
        if ($this->encode_script) {
            return ($this->encode_file)
                 ? mb_convert_encoding($data, $this->encode_script, $this->encode_file)
                 : mb_convert_encoding($data, $this->encode_script);
        } else {
            return $data;
        }
    }
}

?>
