<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceZipsearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹͹ֹ渡APIѡ
 */
require_once 'SyL_WebServiceZipsearchResponse.php';

/**
 * WEBӥꥯȥ饹͹ֹ渡APIѡ
 *
 * ܺ٤ϡWeb ӥ
 *   http://groovetechnology.co.jp/webservice/index.html
 * ͹ֹ渡API
 *   http://groovetechnology.co.jp/webservice/zipsearch/index.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceZipsearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceZipsearchRequest extends SyL_WebServiceGroovetechnology_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'groovetechnology.co.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/ZipSearchService/v1/zipsearch';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceZipsearchResponse';

    /**
     * 󥹥ȥ饯
     * 
     * @access public
     */
    function SyL_WebServiceZipsearchRequest()
    {
        parent::SyL_WebServiceGroovetechnology_co_jpRequest();

        // RESTѥǥե
        $this->setFormat('xml');
        $this->setIe('UTF-8');
        $this->setOe('UTF-8');
    }

    /**
     * ͹ֹ򥻥åȤ
     *
     * @access public
     * @param string ͹ֹ
     */
    function setZipcode($zipcode)
    {
        if (preg_match('/^\d+(\-)?\d+$/', $zipcode)) {
            parent::set('zipcode', $zipcode);
        } else {
            trigger_error("[SyL error] Invalid `zipcode' property ({$zipcode}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ΰ򥻥åȤ
     *
     * @access public
     * @param string ΰ
     */
    function setWord($word)
    {
        parent::set('word', $word);
    }

    /**
     * ϤեޥåȤ򥻥åȤ
     *
     * @access public
     * @param string Ϥեޥå
     */
    function setFormat($format)
    {
        switch ($format) {
        case 'xml':
        case 'json':
        case 'PHP':
            parent::set('format', $format);
            break;
        default:
            trigger_error("[SyL error] Invalid `format' property ({$format}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * JSONPǽϤΥХåؿ̾򥻥åȤ
     *
     * @access public
     * @param string JSONPǽϤΥХåؿ̾
     */
    function setCallback($callback)
    {
        if (preg_match('/^[a-zA-Z0-9_]+$/', $callback)) {
            parent::set('callback', $callback);
        } else {
            trigger_error("[SyL error] Invalid `callback' property ({$callback}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ϥʸʸɤ򥻥åȤ
     *
     * @access public
     * @param string Ϥʸʸ
     */
    function setIe($ie)
    {
        switch ($ie) {
        case 'UTF-8':
        case 'Shift_JIS':
        case 'EUC-JP':
        case 'ISO-2022-JP':
            parent::set('ie', $ie);
            break;
        default:
            trigger_error("[SyL error] Invalid `ie' property ({$ie}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ϻʸɤ򥻥åȤ
     *
     * @access public
     * @param string ϻʸ
     */
    function setOe($oe)
    {
        switch ($oe) {
        case 'UTF-8':
        case 'Shift_JIS':
        case 'EUC-JP':
        case 'ISO-2022-JP':
            parent::set('oe', $oe);
            break;
        default:
            trigger_error("[SyL error] Invalid `oe' property ({$oe}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
