<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchVideoResponse.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ư踡ѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ư踡
 *   http://developer.yahoo.co.jp/search/video/V1/videoSearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchVideoResponse.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceSearchVideoResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ǡΥޥå꡼
     *
     * @access private
     * @var int 
     */
     var $total_results_available = 0;
    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access private
     * @var int 
     */
    var $total_results_returned = 0;
    /**
     * ̤κǽΥݥ
     *
     * @access private
     * @var int 
     */
    var $first_result_position = 0;
    /**
     * ̥ǡ
     *
     * @access private
     * @var array
     */
    var $results = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsAvailable'])) {
                $this->total_results_available = $attribute['totalResultsAvailable'];
            }
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            if (isset($attribute['firstResultPosition'])) {
                $this->first_result_position = $attribute['firstResultPosition'];
            }
            break;
        case '/ResultSet/Result': $i++; break;
        // ưեΥȥ
        case '/ResultSet/Result/Title': $this->results[$i]['Title'] = $text; break;
        // ưե˴Ϣƥȥޥ꡼
        case '/ResultSet/Result/Summary': $this->results[$i]['Summary'] = $text; break;
        // ưե䥹ȥ꡼URL
        case '/ResultSet/Result/Url': $this->results[$i]['Url'] = $text; break;
        // ưեΥURL
        case '/ResultSet/Result/ClickUrl': $this->results[$i]['ClickUrl'] = $text; break;
        // ư襳ƥĤޤڡURL
        case '/ResultSet/Result/RefererUrl': $this->results[$i]['RefererUrl'] = $text; break;
        // ե륵
        case '/ResultSet/Result/FileSize': $this->results[$i]['FileSize'] = $text; break;
        // aviflashmpegmsmediaquicktimeޤrealmediaΤ줫
        case '/ResultSet/Result/FileFormat': $this->results[$i]['FileFormat'] = $text; break;
        // ư褫ե졼ι⤵
        case '/ResultSet/Result/Height': $this->results[$i]['Height'] = $text; break;
        // ư褫ե졼
        case '/ResultSet/Result/Width': $this->results[$i]['Width'] = $text; break;
        // ưեλ
        case '/ResultSet/Result/Duration': $this->results[$i]['Duration'] = $text; break;
        // ǥͥ
        case '/ResultSet/Result/Channels': $this->results[$i]['Channels'] = $text; break;
        // ưե뤬ȥ꡼ߥ
        case '/ResultSet/Result/Streaming': $this->results[$i]['Streaming'] = $text; break;
        // ͥ
        case '/ResultSet/Result/Thumbnail': $this->results[$i]['Thumbnail'] = array(); break;
        // ͥURL
        case '/ResultSet/Result/Thumbnail/Url': $this->results[$i]['Thumbnail']['Url'] = $text; break;
        // ͥι⤵
        case '/ResultSet/Result/Thumbnail/Height': $this->results[$i]['Thumbnail']['Height'] = $text; break;
        // ͥ
        case '/ResultSet/Result/Thumbnail/Width': $this->results[$i]['Thumbnail']['Width'] = $text; break;
        // ե󶡼
        case '/ResultSet/Result/Publisher': $this->results[$i]['Publisher'] = $text; break;
        // Υǥ֥Ȥ»
        case '/ResultSet/Result/Restrictions':  break;
        // ʡΥԡ饤
        case '/ResultSet/Result/Copyright': $this->results[$i]['Copyright'] = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ǡΥޥå꡼
     *
     * @access public
     * @return int ǡΥޥå꡼
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getFirstResultPosition()
    {
        return $this->first_result_position;
    }

    /**
     * ̥ǡ
     *
     * @access public
     * @return array ̥ǡ
     */
    function getResults()
    {
        return $this->results;
    }
}

?>
