<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Index.php,v 1.1 2008/09/23 09:06:16 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륷ƥ९饹
 */
SyL_Loader::lib('Filesystem');
/**
 * ȥޥå׺饹
 */
SyL_Loader::lib('Xml.Sitemap.Writer');

/**
 * ȥޥå׺饹
 *
 * [ sitemap.org ]
 * http://www.sitemaps.org/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Index.php,v 1.1 2008/09/23 09:06:16 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Index extends AppAction
{
    /**
     * ǥեȥե̾
     * Ƭʸ
     *
     * @access private
     * @var string
     */
    var $action_file_default = 'Index.php';
    /**
     * ¹ԥեγĥ
     *
     * @access private
     * @var string
     */
    var $exe_ext = '.php';

    /**
     * ᥤ
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function execute(&$data, &$context)
    {
        $cmd =& $context->getConsole();
        // С󥳥ޥ
        if ($data->is('h') || $data->is('help')) {
            $this->displayHelp($cmd, $data->get(0));
            return;
        // إץޥ
        } else if ($data->is('v') || $data->is('version')) {
            $this->displayVersion($cmd, $data->get(0));
            return;
        }

        $project_dir   = $data->geta('d', 0);
        $app_name      = $data->geta('w', 0);
        $site_root_url = $data->geta('s', 0);
        $output_file   = $data->geta('o', 0);
        $lastmod       = $data->is('l');
        $ext_url       = $data->geta('e', 0);
        $ext_file      = $data->geta('p', 0);

        // -------------------------------------------------
        // ץȥǥ쥯ȥå
        // -------------------------------------------------
        if (!$project_dir) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        }
        if (!is_dir($project_dir)) {
            trigger_error("[SyL error] Project directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }
        $project_dir = realpath($project_dir);

        // -------------------------------------------------
        // ץꥱ̾å
        // -------------------------------------------------
        $app_dir = '';
        if (!$app_name) {
            trigger_error("[SyL error] Application name (-w) not found", E_USER_ERROR);
            exit;
        }
        $app_dir = "{$project_dir}/apps/{$app_name}";
        if (!is_dir($app_dir)) {
            trigger_error("[SyL error] Invalid application. Application directory not found ({$app_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // URLå
        // -------------------------------------------------
        if ($site_root_url === null) {
            trigger_error("[SyL error] Site root url (-s) not found", E_USER_ERROR);
            exit;
        } else {
            if (!preg_match('/^https?:\/\/(.+)/', $site_root_url)) {
                $site_root_url = "http://{$site_root_url}";
                if ($cmd->getInput('', "site root url ({$site_root_url}) [Y/n]:") != 'Y') {
                    $cmd->stdout('*** ' . $data->get(0) . ' stopped');
                    return;
                }
            }
            if (preg_match('/^(.+)\/$/', $site_root_url, $matches)) {
                $site_root_url =  $matches[1];
            }
        }

        // -------------------------------------------------
        // եå
        // -------------------------------------------------
        if ($output_file !== null) {
            if (file_exists($output_file)) {
                if ($cmd->getInput('', "Already output file exist. overwrite file ? ({$output_file}) [Y/n]:") != 'Y') {
                    $cmd->stdout('*** ' . $data->get(0) . ' stopped');
                    return;
                }
                if (!is_writable($output_file)) {
                    trigger_error("[SyL error] Invalid file check. Permission denied ({$output_file})", E_USER_ERROR);
                }
            } else {
                $output_dir = dirname($output_file);
                if (is_dir($output_dir)) {
                    if (!is_writable($output_dir)) {
                        trigger_error("[SyL error] Invalid directory check. Permission denied ({$output_dir})", E_USER_ERROR);
                    }
                } else {
                    trigger_error("[SyL error] Output directory not found ({$output_dir})", E_USER_ERROR);
                }
            }
        }

        // -------------------------------------------------
        // ꥢץꥱե
        // -------------------------------------------------
        $project_config_file = "{$project_dir}/config/defines.xml";
        $app_config_file     = "{$project_dir}/apps/{$app_name}/config/defines.xml";

        if (!is_file($project_config_file)) {
            trigger_error("[SyL error] `defines.xml' not found in project directory({$project_config_file})", E_USER_ERROR);
        }

        $config =& SyL_Config::factory('defines');
        $config->setConfigFiles(array($app_config_file, $project_config_file));
        $config->parseXml(false, false);
        $values = $config->getConfig();

        if (!isset($values['SYL_ROUTER_URL_EXT']) || !$values['SYL_ROUTER_URL_EXT']) {
            trigger_error("[SyL error] `SYL_ROUTER_URL_EXT' constant not defined in config file({$project_config_file} or {$app_config_file})", E_USER_ERROR);
        }

        // -------------------------------------------------
        // ĥ
        // -------------------------------------------------
        if (!$ext_url)  $ext_url  = $values['SYL_ROUTER_URL_EXT'];
        if (!$ext_file) $ext_file = $values['SYL_ROUTER_URL_EXT'];

        if ($ext_url && ($ext_url[0] != '.')) {
            $ext_url = ".{$ext_url}";
        }
        if ($ext_file && ($ext_file[0] != '.')) {
            $ext_file = ".{$ext_file}";
        }

        // ץꥱΥƥץ졼ȥǥ쥯ȥ
        $template_dir = "{$app_dir}/templates";

        $writer =& new SyL_XmlSitemapWriter();
        $writer->setInternalEncode(SYL_ENCODE_INTERNAL);
        foreach (SyL_Filesystem::getFiles($template_dir, false, true, null) as $file) {
            $filename = $file->getName();
            if (preg_match('/^(' . preg_quote($template_dir, '/') . ')(.+)(' . preg_quote($ext_file) . ')$/', $filename, $matches)) {
                $url     = '';
                $skip    = false;
                $default = false;
                // ǥեURL/ ǽURLˤΥեȽ
                if ($this->action_file_default == basename($matches[2] . $this->exe_ext)) {
                    $default = true;
                }
                foreach (preg_split('/[\\\\\/]/', $matches[2].$ext_url) as $tmp) {
                    if ($tmp) {
                        // ƬʸΤо
                        if (preg_match('/^[A-Z0-9]/', $tmp)) {
                            // URLǥϡƬʸ
                            $tmp[0] = strtolower($tmp[0]);
                            $url .= "/{$tmp}";
                        } else {
                            $skip = true;
                            break;
                        }
                    }
                }
                if ($url && !$skip) {
                    $url       = $site_root_url . $url;
                    $timestamp = $lastmod ? filemtime($filename) : null;
                    if ($default) {
                        $writer->addUrl(dirname($url) . '/', $timestamp);
                    }
                    $writer->addUrl($url, $timestamp);
                }
            }
        }

        // ȥޥå׺
        if ($output_file) {
            $writer->save($output_file);
        } else {
            echo $writer->create();
        }
    }

    /**
     * إפɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayHelp(&$cmd, $file)
    {
        $help = <<<EOF
Usage:
  php {$file} -d <dir> -w <name> -s <site> [-o <file>] [-l] [-e <ext>] [-p <ext>]
  php {$file} [option]

Options:
  -d <dir>  project directory
  -w <name> application name
  -s <site> root URL
  -o <file> output file (default: standard output)
  -l        add lastmod Tag (default: none)
  -e <ext>  extention name for URL access (default: SYL_ROUTER_URL_EXT in defines.xml)
  -p <ext>  extention name for physical file (default: SYL_ROUTER_URL_EXT in defines.xml)
EOF;
        $cmd->stdout($help);
    }

    /**
     * Сɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayVersion(&$cmd, $file)
    {
        $syl_version = SYL_VERSION;
        $php_version = PHP_VERSION;
        $php_sapi    = PHP_SAPI;
        $php_os      = PHP_OS;
       // $php_version = PHP_SAPI;
        $version = <<<EOF
{$file} - SyL {$syl_version} (PHP {$php_version} {$php_sapi} - {$php_os})
Copyright (C) 2006-2008 k.watanabe
EOF;
        $cmd->stdout($version);
    }

    /**
     * ǥեɽ
     *
     * @access private
     * @param object ޥɥ֥
     * @param string ¹ԥե̾
     */
    function displayDefault(&$cmd, $file)
    {
        $default = <<<EOF
{$file}: too few arguments
Try `php {$file} --help' for more information.
EOF;
        $cmd->stdout($default);
    }
}

?>
