<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigActions.php,v 1.30 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 󥯥饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Action.php';

/**
 * եɤ߹९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ConfigActions.php,v 1.30 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ConfigActions extends SyL_Config
{
    /**
     * ե̾
     * 
     * @access private
     * @var string
     */
    var $config_file_name = 'actions.xml';
    /**
     * ٥̾
     * 
     * @access protected
     * @var string
     */
    var $event = 'executeStream';
    /**
     * ǥեȼ¹Խ
     * 
     * @access protected
     * @param int
     */
    var $default_priority = 5;
    /**
     * ǥեȥ᥽å̾
     * 
     * @access private
     * @param string
     */
    var $default_method = 'execute';
    /**
     * pre¹ԥ᥽å̾
     * 
     * @access private
     * @param string
     */
    var $pre_method = 'preExecute';
    /**
     * ڼ¹ԥ᥽å̾
     * 
     * @access private
     * @param string
     */
    var $validate_method = 'validate';
    /**
     * post¹ԥ᥽å̾
     * 
     * @access private
     * @param string
     */
    var $post_method = 'postExecute';
    /**
     * ƥʥ̾
     * 
     * @access private
     * @var object
     */
    var $action_key = SYL_ACTION_KEY;

    /**
     * ե򥻥å
     *
     * @access protected
     */
    function setProjectConfigFiles()
    {
        $this->file_names[] = SYL_APP_CONFIG_DIR . "/{$this->config_file_name}";
    }

    /**
     * XMLեβϽ
     *
     * @access public
     * @param bool åͭե饰
     */
    function parseXml($enable_cache=true)
    {
        // ١饹
        SyL_Loader::lib(SYL_ACTION_BASE_CLASS);

        if (SYL_CACHE && $enable_cache) {
            // åѤ
            $key = SYL_APP_DIR . $this->context->getActionFile() . $this->context->getActionName();
            $cache =& $this->getCache($key);
            if ($cache) {
                // å夬Ǥʤäʥå奪֥Ȥ
                parent::parseXml();
                // ¹Խѹ
                $this->changeActionOrder();
                // 󥤥٥ȥ᥽å
                $this->setEvents();
                // 򥭥å岽
                $cache->write($this->config);
            }
        } else {
            // åѤʤ
            parent::parseXml();
            // ¹Խѹ
            $this->changeActionOrder();
            // 󥤥٥ȥ᥽å
            $this->setEvents();
        }

        if (!isset($this->config[$this->action_key])) {
            // б륢ޥåԥ󥰤¸ߤʤ
            trigger_error("[SyL error] Action mapping not found (" . $this->context->getActionFile() . ")", E_USER_ERROR);
        }
    }

    /**
     * XMLǡƼϥɥ᥽å
     * С饤
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $name             = '';
        static $pre_name         = '';
        static $post_name        = '';

        static $method_name      = '';
        static $pre_method_name  = '';
        static $post_method_name = '';

        static $component_name   = '';
        static $load             = false;

//echo $current_path . "<br>";
        // 1ɺѤߤξʹߥå
        if ($load) return;

        // XMLϷ̤
        switch ($current_path) {
        case '/syl-actions/action':
            if ($name != '') {
                $name = '';
                $load = true;
                return;
            }
            if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                return;
            }

            // URLǧ
            $reg = isset($attribute['path']) ? str_replace('/', '\\/', $attribute['path']) : '(.*)';
            if (preg_match('/^' . $reg . '$/', $this->context->getActionFile(), $matches)) {
                $name  = $this->action_key;
                // ǥեȥ
                $class = $this->context->getClassName();
                $file  = $this->context->getActionDir() . $this->context->getActionFile();
                // ǥե¸Ƚ
                if (!is_file($file)) {
                    $class = SyL_Loader::convertClass(SYL_ACTION_BASE_CLASS);
                    $file  = SYL_APP_LIB_DIR . SyL_Loader::convertPath(SYL_ACTION_BASE_CLASS);
                }
                // ݡͥȥѥ᡼
                $this->config[$name] = array(
                    'class'       => $class,
                    'type'        => 'action',
                    'file'        => $file,
                    'reference'   => true,
                    'priority'    => $this->default_priority, // ¹Խ
                    'constructor' => false, // 󥹥ȥ饯󥸥ե饰
                    'force'       => (SYL_ENV_TYPE == 'cmd'), // ե뤬¸ߤʤȥ顼Υե饰 ޥɥ饤Τߥե¸ߥå
                    'args'        => array() // 
                );

                // ٥ȥʥ֥Ⱥ
                $this->config[$name]['event'][$this->event][] = $name;

                $method_name = '';
                if (isset($attribute['method'])) {
                    $method_name = 'method:' . str_replace('{action}', $this->context->getActionName(), $attribute['method']);
                } else {
                    // ᥽åɤΥǥե
                    $method_name = 'method:' . $this->default_method;
                }
                // ᥽åɤΰϸ
                $this->config[$name]['args'][$method_name] = array();
                $this->config[$name]['args'][$method_name][] = 'component:true:data';
                $this->config[$name]['args'][$method_name][] = 'component:true:context';

                $this->config[$name]['event'][$this->event][] = $method_name; // ٥ȥ
            }
            break;

        default:
            if (!$name) return;

            switch ($current_path) {
            case '/syl-actions/action/setter':
                // 쥯ȥåȥ
                if (isset($attribute['direct']) && ($attribute['direct'] === 'true')) {
                    $method_name = 'setter:' . $attribute['name'] . ':true';
                } else {
                    $method_name = 'setter:set' . ucfirst($attribute['name']) . ':false';
                }
                $this->config[$name]['event'][$this->event][] = $method_name;
                $this->config[$name]['args'][$method_name]    = array();
                break;

            case '/syl-actions/action/method':
                $method_name = 'method:' . $attribute['name'];
                $this->config[$name]['event'][$this->event][] = $method_name; // ٥ȥ
                $this->config[$name]['args'][$method_name] = array();
                break;

            case '/syl-actions/action/setter/arg':
            case '/syl-actions/action/method/arg':
                $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                $arg  = "{$type}:{$ref}:{$text}";
                $this->config[$name]['args'][$method_name][] = $arg;
                break;

           case '/syl-actions/action/components/component':
                if (isset($attribute['enable']) && ($attribute['enable'] === 'false')) {
                    $component_name = '';
                    return;
                }
                $component_name = $attribute['name'];
                $this->config[$component_name]['type']      = 'component';
                $this->config[$component_name]['class']     = isset($attribute['class'])  ? $attribute['class'] : $component_name;
                $this->config[$component_name]['file']      = $attribute['file'];
                $this->config[$component_name]['reference'] = (isset($attribute['reference']) && ($attribute['reference'] === 'true'));
                // ¹Խ(2ʳᤤ)
                $default_priority = $this->default_priority - 2;
                $component_priority = isset($attribute['priority']) ? floatval($default_priority . '.' . $attribute['priority']) : $default_priority;
                $this->config[$component_name]['priority'] = $component_priority;
                // 󥹥ȥ饯󥸥ե饰
                $this->config[$component_name]['constructor'] = false;
                // ե뤬¸ߤʤȥ顼Υե饰
                $this->config[$component_name]['force'] = false;
                // ٥ȥ
                $this->config[$component_name]['event'][$this->event][] = $component_name;
                // 
                $this->config[$component_name]['args'] = array();
                break;

            default:
                if (!$component_name) return;

                switch ($current_path) {
                case '/syl-actions/action/components/component/constructor':
                    $method_name = 'constructor:' . (isset($attribute['static']) ? $attribute['static'] : '');
                    // 󥹥ȥ饯󥸥ե饰
                    $this->config[$component_name]['constructor'] = true;
                    // 󥹥ȥ饯󥸥ξ硢Υ᥽åɤϺ
                    $index = array_search($component_name, $this->config[$component_name]['event'][$this->event]);
                    if ($index !== false) {
                        unset($this->config[$component_name]['event'][$this->event][$index]);
                    }
                    $this->config[$component_name]['event'][$this->event][] = $method_name;
                    $this->config[$component_name]['args'][$method_name] = array();
                    break;

                case '/syl-actions/action/components/component/setter':
                    // 쥯ȥåȥ
                    if (isset($attribute['direct']) && ($attribute['direct'] === 'true')) {
                        $method_name = 'setter:' . $attribute['name'] . ':true';
                    } else {
                        $method_name = 'setter:set' . ucfirst(strtolower($attribute['name'])) . ':false';
                    }
                    $this->config[$component_name]['event'][$this->event][] = $method_name;
                    $this->config[$component_name]['args'][$method_name] = array();
                    break;

                case '/syl-actions/action/components/component/method':
                    $method_name = 'method:' . $attribute['name'];
                    $this->config[$component_name]['event'][$this->event][] = $method_name;
                    $this->config[$component_name]['args'][$method_name] = array();
                    break;

                case '/syl-actions/action/components/component/setter/arg':
                case '/syl-actions/action/components/component/constructor/arg':
                case '/syl-actions/action/components/component/method/arg':
                    $type = isset($attribute['type']) ? $attribute['type'] : 'value';
                    $ref  = (isset($attribute['reference']) && ($attribute['reference'] === 'true')) ? 'true' : 'false';
                    $this->config[$component_name]['args'][$method_name][] = $type . ':' . $ref . ':' . $text;
                    break;
                }
            }
        }
    }

    /**
     * ¹ԥ᥽åɤν֤ѹ
     * ˥ݡͥȤΥ󥸥󤬤
     *
     * @access private
     */
    function changeActionOrder()
    {
        $name = $this->action_key;

        // 󥸥̵ϥ롼
        if (count($this->config[$name]['event'][$this->event]) <= 2) {
            return;
        }

        $method = array_splice($this->config[$name]['event'][$this->event], 1, 1);
        array_push($this->config[$name]['event'][$this->event], $method[0]);

        // ϢνѹΤƬͤ
        $main_args = array();
        foreach ($this->config[$name]['args'] as $key => $arg) {
            $main_args[$key] = $arg;
            break;
        }

        array_shift($this->config[$name]['args']);
        foreach ($main_args as $key => $arg) {
            $this->config[$name]['args'][$key] = $arg;
        } 
    }


    /**
     * 󥤥٥ȥ᥽åɤ
     *
     * @access private
     */
    function setEvents()
    {
        $name = $this->action_key;

        // ᥽åɰ
        $args = array();
        $args[0] = 'component:true:data';
        $args[1] = 'component:true:context';

        // ϢνѹΤ¸
        $main_args = $this->config[$name]['args'];

        // 
        $this->config[$name]['args'] = array();

        // preExecute 
        $method = 'method:' . $this->pre_method;
        array_splice($this->config[$name]['event'][$this->event], 1, 0, $method);
        $this->config[$name]['args'][$method] = $args;

        // validate 
        $method = 'method:' . $this->validate_method;
        array_splice($this->config[$name]['event'][$this->event], 2, 0, $method);
        $this->config[$name]['args'][$method] = $args;

        // execute 
        $this->config[$name]['args'] += $main_args;

        // postExecute 
        $method = 'method:' . $this->post_method;
        array_push($this->config[$name]['event'][$this->event], $method);
        $this->config[$name]['args'][$method] = $args;
    }
}

?>
