<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataWeb.php,v 1.9 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * JavaScriptǡݻ饹
 */
require_once 'SyL_DataJs.php';

/**
 * ǡݻ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DataWeb.php,v 1.9 2008/06/20 17:41:54 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DataWeb extends SyL_DataJs
{
    /**
     * ϥѥ᡼򥻥å
     * 
     * @access public
     */
    function initInputs()
    {
        // ѥ᡼
        $this->setInputs(($_SERVER['REQUEST_METHOD'] == 'POST') ? $_POST + $_GET : $_GET + $_POST);
        // ޥåݥȤͭȽ
        if (get_magic_quotes_gpc()) {
            $this->apply('stripslashes');
        }
        // ʸɥåɲ
        if (function_exists('mb_check_encoding')) {
            $this->applyCheckEncodingRecursive($this->input_parameters, SYL_ENCODE_INTERNAL);
        }

        // JSݡȥѥ᡼
        if ($this->import_parameter) {
            $this->setImportParameter();
        }
    }

    /**
     * ǸŪ˥ѥ᡼᥽å
     * 
     * @access public
     * @return array ѥ᡼
     */
    function finalOutputs()
    {
        $parameters = $this->gets(false);
        $this->deletes();
        return $parameters;
    }
}

?>
