<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayoutSmarty.php,v 1.12 2008/08/31 13:58:49 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 쥤ȥӥ塼饹
 */
require_once 'SyL_ViewLayout.php';
/**
 * Smarty饹
 */
require_once SYL_SMARTY_DIR . 'Smarty.class.php';

/**
 * Smarty쥤ȥ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewLayoutSmarty.php,v 1.12 2008/08/31 13:58:49 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ViewLayoutSmarty extends SyL_ViewLayout
{
    /**
     * Smarty֥
     * 
     * @var object
     */
    var $smarty = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_ViewLayoutSmarty(&$context, &$data)
    {
        parent::SyL_ViewLayout($context, $data);

        $this->smarty =& new Smarty();
        if (SYL_SMARTY_PARAMETER) {
            foreach(explode(';', SYL_SMARTY_PARAMETER) as $properties) {
                $tmp = explode('=', $properties, 2);
                if (count($tmp) == 2) {
                    list($name, $value) = $tmp;
                    if (isset($this->smarty->$name)) {
                        $this->smarty->$name = $value;
                    }
                }
            }
        }
    }

    /**
     * HTML󥰼¹
     * 
     * @access public
     */
    function render()
    {
        // 󤫤Υѥ᡼
        $values =& $this->getActionValues();
        foreach (array_keys($values) as $key) {
            if (is_object($values[$key])) {
                $this->smarty->assign_by_ref($key, $values[$key]);
            } else {
                $this->smarty->assign($key, $values[$key]);
            }
        }

        // ƥץ졼ȥǥ쥯ȥꥻå
        $this->smarty->template_dir = $this->getTemplateDir();
        // ɽƤ򥻥å
        $this->setRender($this->smarty->fetch($this->getTemplateFile()));
    }
}

?>
