<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDriverOci8.php,v 1.4 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  DB饹Oracle
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDriverOci8.php,v 1.4 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBDriverOci8 extends SyL_DB
{
    /**
     * ơȥ
     *
     * @access private
     * @var resource
     */
    var $stmt = null;

    /**
     * 󥳡Ѵơ֥
     *
     * ƾʸǵ
     *
     * @access protected
     * @var string
     */
    var $encode_table = array(
      // PHP, DB
      array('eucjp-win', 'japanese_japan.ja16euc'),
      array('euc-jp',    'japanese_japan.ja16euc'),
      array('euc',       'japanese_japan.ja16euc'),
      array('sjis-win',  'japanese_japan.ja16sjis'),
      array('sjis',      'japanese_japan.ja16sjis'),
      array('utf-8',     'japanese_japan.utf8')
    );

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        $dbname_tmp = $dbname;
        if ($host) {
            $dbname_tmp = ($port) ? "{$host}:{$port}/{$dbname_tmp}" : "{$host}/{$dbname_tmp}";
        }
        if ($this->client_encode) {
            $this->connection = $persistent ? ociplogon($user, $passwd, $dbname_tmp, $this->client_encode) : ocilogon($user, $passwd, $dbname_tmp, $this->client_encode);
        } else {
            $this->connection = $persistent ? ociplogon($user, $passwd, $dbname_tmp) : ocilogon($user, $passwd, $dbname_tmp);
        }
        return is_resource($this->connection);
    }

    /**
     * DB³λ
     * 
     * @access public
     */
    function closeConnection()
    {
        if (is_resource($this->connection)) {
            ocilogoff($this->connection);
            $this->connection = null;
        }
    }

    /**
     * 饤¦ʸ󥳡ƥ
     * 
     * @access public
     * @param string DBʸ
     * @param string PHP¦󥳡
     */
    function setClientEncoding($client_encode, $server_encode='')
    {
        $client_encode2 = strtolower($client_encode);
        foreach ($this->encode_table as $encode_table) {
            if ($encode_table[0] == $client_encode2) {
                $client_encode2 = $encode_table[1];
                break;
            }
        }
        putenv("NLS_LANG={$client_encode2}");
        parent::setClientEncoding($client_encode, $server_encode);
    }

    /**
     * Ǹ˵ä顼å򥻥å
     *
     * @access public
     * @param string 顼
     * @param string 顼å
     */
    function setErrorMessage($code='', $message='')
    {
        if ($code) {
            parent::setErrorMessage($code, $message);
        } else {
            $error = false;
            if ($this->stmt) {
                $error = $this->stmt ? ocierror($this->stmt) : ocierror();
            } else {
                $error = $this->connection ? ocierror($this->connection) : ocierror();
            }
            if ($error) {
                $this->last_error_code    = $error['code'];
                $this->last_error_message = $error['message'];
            }
        }
    }

    /**
     * ѥ᡼˥̵˽
     * 
     * @access public
     * @param string ˥оʸ
     * @return string ˥ʸ
     */
    function escape($parameter)
    {
        return str_replace("'", "''", $parameter);
    }

    /**
     * ȥ󥶥󳫻
     *
     * @access public
     */
    function beginTransaction()
    {
        parent::beginTransaction();
    }

    /**
     * ȥ󥶥˴
     *
     * @access public
     */
    function rollBack()
    {
        @ocirollback($this->connection);
        parent::rollBack();
    }

    /**
     * ȥ󥶥
     *
     * @access public
     */
    function commit()
    {
        @ocicommit($this->connection);
        parent::commit();
    }

    /**
     * SQL¹ԤDB꥽
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: DB꥽, ¹NG: false
     */
    function execSelect($sql)
    {
        if ($this->createStatement($sql)) {
            return $this->stmt;
        } else {
            $this->setErrorMessage();
            $this->closeStatement();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ¹Է̱ƶ
     *
     * @access public
     * @param string SQLʸ
     * @return mixed ¹OK: ¹Է̱ƶ, ¹NG: false
     */
    function execUpdate($sql)
    {
        if ($this->createStatement($sql)) {
            $num = ocirowcount($this->stmt);
            $this->closeStatement();
            return $num;
        } else {
            $this->setErrorMessage();
            $this->closeStatement();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹ԤΤ
     *
     * @access public
     * @param string SQLʸ
     * @return boolean ¹OK: true, ¹NG: false
     */
    function execNoReturn($sql)
    {
        if ($this->createStatement($sql)) {
            return true;
        } else {
            $this->setErrorMessage();
            $this->closeStatement();
            $this->triggerError();
            return false;
        }
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    function queryRef($sql, &$data, $get='all')
    {
        // SQL¹
        $this->execRef($sql, $query);
        // Ƚ
        if (!is_resource($query)) {
            $data = $query;
            return ($query !== false);
        }
        switch ($get) {
        // 1ե
        case 'one':
            $tmp = array();
            if (ocifetchinto($this->stmt, $tmp, OCI_NUM + OCI_RETURN_NULLS) > 0) {
                $data = $tmp[0];
            } else {
                $data = '';
            }
            break;
        // 1쥳
        case 'record':
            $data = array();
            if (ocifetchinto($this->stmt, $data, OCI_ASSOC + OCI_RETURN_NULLS)) {
                $data = $this->caseFieldName($data);
            } else {
                $data = array();
            }
            break;
        // 쥳
        case 'all':
            $data = array();
            $tmp  = array();
            while (ocifetchinto($this->stmt, $tmp, OCI_ASSOC + OCI_RETURN_NULLS)) {
                $data[] = $tmp;
            }
            break;
        }
        $this->closeStatement();
        return true;
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    function queryPageRef($sql, &$result, &$pager, $limit=20, $page=1)
    {
        // ڡ󥰥֥
        $pager = $this->getPager($limit, $page);
        // SQL
        $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") SyL$";
        // SQL¹
        if (!$this->queryRef($sql_count, $record, 'one')) return false;
        $pager->setCountAll($record);

        // ڡñ̥쥳ɼ
        $sql_page  =  "";
        $sql_page .= "SELECT ";
        $sql_page .=   "SyL2$.* ";
        $sql_page .= "FROM ";
        $sql_page .=   "(";
        $sql_page .=     "SELECT ";
        $sql_page .=       "SyL$.*, ";
        $sql_page .=       "ROWNUM as ROWNUM$ ";
        $sql_page .=     "FROM ";
        $sql_page .=       "(" . $sql . ") SyL$ ";
        $sql_page .=   ") SyL2$ ";
        $sql_page .= "WHERE ";
        $sql_page .=   "ROWNUM$ BETWEEN " . ($pager->getStartOffset() + 1) . " AND " . ($pager->getStartOffset() + $pager->getCount());

        // ǡSQL¹
        return $this->queryRef($sql_page, $result, 'all');
    }

    /**
     * SQLѡơȥȥ꥽
     *
     * @access private
     * @param string SQLʸ
     * @return bool true: SQL¹OKfalse: SQLѡ¹ԥ顼
     */
    function createStatement($sql)
    {
        $this->closeStatement();
        $this->stmt = ociparse($this->connection, $sql);
        if (!$this->stmt) {
            return false;
        }
        return ($this->transaction) ? @ociexecute($this->stmt, OCI_DEFAULT)
                                    : @ociexecute($this->stmt, OCI_COMMIT_ON_SUCCESS);
    }

    /**
     * ơȥȥ꥽
     *
     * @access private
     */
    function closeStatement()
    {
        if (is_resource($this->stmt)) {
            ocifreestatement($this->stmt);
            $this->stmt = null;
        }
    }

    /**
     * Ǹ줿Ԥ ID 뤤ϥ󥹤ͤ
     *
     * @access public
     * @return int Ǹ줿ԤID
     */
    function lastInsertId($seq='')
    {
        $sql = "SELECT CURRVAL('{$seq}') FROM DUAL";
        $this->queryRef($sql, $data, 'one');
        return $data;
    }

    /**
     * ³ƤDBСΥС
     * 
     * @access public
     * @return string DBΥС
     */
    function getVersion()
    {
        $sql = 'SELECT BANNER FROM V$VERSION';
        $this->queryRef($sql, $versions, 'one');
        $version = false;
        if (preg_match ('/ ([\d\.]+) \-/', $versions, $matches)) {
            $version = $matches[1];
        }
        return $version;
    }
}

?>
