<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailMessage.php,v 1.1 2008/01/20 15:09:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ᡼å饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_MailMessage.php,v 1.1 2008/01/20 15:09:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_MailMessage
{
    /**
     * 
     * 
     * @access private
     * @var string
     */
    var $from = array();
    /**
     * ֿ᡼륢ɥ쥹
     * 
     * @access private
     * @var string
     */
    var $reply_to = '';
    /**
     * 
     * 
     * @access private
     * @var array
     */
    var $to = array();
    /**
     * CC᡼륢ɥ쥹
     * 
     * @access private
     * @var array
     */
    var $cc = array();
    /**
     * BCC᡼륢ɥ쥹
     * 
     * @access private
     * @var array
     */
    var $bcc = array();
    /**
     * ̾
     * 
     * @access private
     * @var string
     */
    var $subject = '';
    /**
     * MIMEС
     * 
     * @access protected
     * @var string
     */
    var $mime_version = '1.0';
    /**
     * ʸ
     *
     * [body]              - ʸ
     * [name]              - źեե̾
     * [file]              - źեե
     * [type]              - Content-Type
     * [transfer_encoding] - Content-Transfer-Encoding
     * 
     * @access protected
     * @var array
     */
    var $attachments = array();
    /**
     * 󥳡
     *
     * Base64Τб
     * 
     * B: base64
     * Q: Quoted-Printable
     * 
     * @access protected
     * @var string
     */
    var $transfer_encoding = 'B';
    /**
     * X-Mailerإå
     * 
     * @access protected
     * @var string
     */
    var $x_mailer = 'SyL Mail 1.0';
    /**
     * ¾إå
     * 
     * @access protected
     * @var array
     */
    var $headers = array();
    /**
     * ᡼ƤΥ󥳡
     * 
     * @access protected
     * @var string
     */
    var $mail_encode = '';
    /**
     * ץ¦Υ󥳡
     * 
     * @access protected
     * @var string
     */
    var $internal_encode = '';
    /**
     * 
     * 
     * @access protected
     * @var string
     */
    var $language = '';
    /**
     * 
     * 
     * @access protected
     * @var string
     */
    var $eol = "\r\n";

    /**
     * ɥ쥹򥻥å
     *
     * @access public
     * @param string ɥ쥹
     * @param string ̾
     */
    function setFrom($from, $name='')
    {
        $this->from = array($from, $name);
        if ($this->reply_to == '') {
            $this->reply_to = $from;
        }
    }

    /**
     * ɥ쥹
     *
     * @access public
     * @return array ɥ쥹
     */
    function getFrom()
    {
        return $this->from;
    }

    /**
     * 襢ɥ쥹򥻥å
     * 
     * @access public
     * @param mixed 襢ɥ쥹
     * @param string ̾
     */
    function addTo($to, $name='')
    {
        $this->to[] = array($to, $name);
    }

    /**
     * 襢ɥ쥹
     *
     * @access public
     * @return array ɥ쥹
     */
    function getTo()
    {
        return $this->to;
    }

    /**
     * 襢ɥ쥹(CC)򥻥å
     * 
     * @access public
     * @param mixed 襢ɥ쥹(CC)
     * @param string ̾(CC)
     */
    function addCc($cc, $name='')
    {
        $this->cc[] = array($cc, $name);
    }

    /**
     * 襢ɥ쥹(CC)
     *
     * @access public
     * @return array ɥ쥹(CC)
     */
    function getCc()
    {
        return $this->cc;
    }

    /**
     * 襢ɥ쥹(BCC)򥻥å
     * 
     * @access public
     * @param mixed 襢ɥ쥹(BCC)
     * @param string ̾(BCC)
     */
    function addBcc($bcc, $name='')
    {
        $this->bcc[] = array($bcc, $name);
    }

    /**
     * 襢ɥ쥹(BCC)
     *
     * @access public
     * @return array ɥ쥹(BCC)
     */
    function getBcc()
    {
        return $this->bcc;
    }

    /**
     * ̾򥻥å
     * 
     * @access public
     * @param string ̾
     */
    function setSubject($subject)
    {
        $this->subject = $subject;
    }

    /**
     * ̾
     * 
     * @access public
     * @return string ̾
     */
    function getSubject()
    {
        return $this->subject;
    }

    /**
     * ʸ򥻥å
     * 
     * @access public
     * @param string ʸ
     */
    function setBody($body)
    {
        $this->attachments[] = array(
          'body'              => $body,
          'type'              => 'text/plain; charset="' . $this->mail_encode . '"',
          'transfer_encoding' => '7bit',
          'name'              => null,
          'file'              => null
        );
    }

    /**
     * ʸ
     * 
     * @access public
     * @param string ʸ
     */
    function getBody()
    {
        return $this->attachments;
    }

    /**
     * ᡼륨󥳡ɤ򥻥åȤ
     *
     * @access public
     * @param string ᡼륨󥳡
     */
    function setMailEncode($mail_encode)
    {
        $this->mail_encode = $mail_encode;
    }

    /**
     * ѥ᡼󥳡ɤ򥻥åȤ
     *
     * @access public
     * @param string ѥ᡼󥳡
     */
    function setInternalEncode($internal_encode)
    {
        $this->internal_encode = $internal_encode;
    }

    /**
     * 򥻥åȤ
     *
     * @access public
     * @param string 
     */
    function setLanguage($language)
    {
        $this->language = $language;
    }

    /**
     * ¾Υ᡼إå򥻥å
     * 
     * @access public
     * @param string إåΥ
     * @param string إå
     */
    function addHeader($key, $value)
    {
        $this->headers[$key] = $value;
    }

    /**
     * ¾Υ᡼إå
     * 
     * @access public
     * @return array ¾Υ᡼إå
     */
    function getHeader($key)
    {
        return isset($this->headers[$key]) ? $this->headers[$key] : null;
    }

    /**
     * źեե򥻥å
     * 
     * @access public
     * @param string եѥʥե̾ޤǴޤ
     */
    function addFile($path, $contents_type='application/octet-stream')
    {
        // ե̾
        $name = basename($path);
        // źեե
        $contents = file_get_contents($path);
        switch ($this->transfer_encoding) {
        case 'B':
            $contents = chunk_split(base64_encode($contents));
            $transfer_encoding = 'Base64';
            break;
        default:
            trigger_error("[SyL error] Content-Transfer-Encoding not supported ({$this->transfer_encoding})", E_USER_ERROR);
            break;
        }

        // źեե󥻥å
        $this->attachments[] = array(
          'body'              => null,
          'type'              => $contents_type,
          'transfer_encoding' => $transfer_encoding,
          'name'              => $this->convertEncoding($name, true),
          'file'              => $contents
        );
    }

    /**
     * RCPT_TOѥ᡼륢ɥ쥹ꥹȤ
     * 
     * @access public
     * @return array RCPT_TOѥ᡼륢ɥ쥹ꥹ
     */
    function getRcptTo()
    {
        $rcptto = array();
        foreach ($this->to as $to) {
            if (array_search($to[0], $rcptto) === false) {
                $rcptto[] = $to[0];
            }
        }
        foreach ($this->cc as $cc) {
            if (array_search($cc[0], $rcptto) === false) {
                $rcptto[] = $cc[0];
            }
        }
        foreach ($this->bcc as $bcc) {
            if (array_search($bcc[0], $rcptto) === false) {
                $rcptto[] = $bcc[0];
            }
        }
        return $rcptto;
    }

    /**
     * ѥ᡼᡼ʸ˥󥳡ɤ
     *
     * @access public
     * @param string 󥳡оʸ
     * @param bool MIME󥳡ɥե饰
     * @return 󥳡ɸʸ
     */
    function convertEncoding($parameter, $mime_encode=false)
    {
        $parameter = mb_convert_encoding(mb_convert_kana($parameter, 'KV', $this->internal_encode), $this->mail_encode, $this->internal_encode);
        if ($mime_encode) {
            $language = mb_language();
            mb_language($this->language);
            $internal_encode = mb_internal_encoding();
            mb_internal_encoding($this->mail_encode);
            $parameter = mb_encode_mimeheader($parameter, $this->mail_encode, $this->transfer_encoding);
            mb_internal_encoding($internal_encode);
            mb_language($language);
        }
        return $parameter;
    }

    /**
     * ᡼륢ɥ쥹᡼ʸ˥󥳡ǥ
     * 
     * @access public
     * @param string ᡼륢ɥ쥹
     * @param string ᡼륢ɥ쥹̾
     * @return string 󥳡ǥ󥰤Υ᡼륢ɥ쥹
     */
    function convertEncodingAddress($address, $name='')
    {
        if ($name) {
            return '"' . $this->convertEncoding($name, true) . '" <' . $address . '>';
        } else {
            return $address;
        }
    }

    /**
     * ᡼ʸѥ᡼˥ǥɤ
     *
     * @access public
     * @param string ǥоʸ
     * @param bool MIME󥳡ɥե饰
     * @return ǥɸʸ
     */
    function convertDecoding($parameter, $mime_encode=false)
    {
        if ($mime_encode) {
            $language = mb_language();
            mb_language($this->language);
            $internal_encode = mb_internal_encoding();
            mb_internal_encoding($this->mail_encode);
            $parameter = mb_decode_mimeheader($parameter);
            mb_internal_encoding($internal_encode);
            mb_language($language);
        }
        return mb_convert_encoding($parameter, $this->internal_encode, $this->mail_encode);
    }

    /**
     * ᡼ʸ᡼륢ɥ쥹˥ǥǥ
     * 
     * @access public
     * @param string ᡼륢ɥ쥹
     * @return array ᡼륢ɥ쥹ȥ᡼륢ɥ쥹̾
     */
    function convertDecodingAddress($address)
    {
        if (preg_match('/^(.*)[ ]*<(.+@.+)>$/', $address, $matches)) {
            switch (count($matches)) {
            case 3:
                $matches[1] = trim($matches[1]);
                if (preg_match('/^"(.+)"$/', $matches[1], $matches1)) {
                    $matches[1] = $matches1[1];
                }
                return array($matches[2], $this->convertDecoding(trim($matches[1]), true));
            case 2: return array($matches[2], '');
            }
        } else {
            return array($address, '');
        }
    }

    /**
     * ᡼å
     *
     * @access public
     * @param bool SMTPʸ
     * @return string ᡼إåޤʸ
     */
    function getMessage($body_escape=false)
    {
        // Х
        $boundary = '--' . md5(uniqid(rand()));

        // Fromɬ
        if (count($this->from) != 2) {
            trigger_error("[SyL error] From Address not found", E_USER_ERROR);
        }
        // Toɬ
        if (count($this->to) == 0) {
            trigger_error("[SyL error] To Address not found", E_USER_ERROR);
        }

        // ᡼إå
        $data  = '';
        $data .= "From: "     . $this->convertEncodingAddress($this->from[0], $this->from[1]) . $this->eol;
        $data .= "Subject: "  . $this->convertEncoding($this->subject, true) . $this->eol;
        for ($i=0; $i<count($this->to); $i++) {
            $data .= "To: " . $this->convertEncodingAddress($this->to[$i][0], $this->to[$i][1]) . $this->eol;
        }
        for ($i=0; $i<count($this->cc); $i++) {
            $data .= "Cc: " . $this->convertEncodingAddress($this->cc[$i][0], $this->cc[$i][1]) . $this->eol;
        }
        for ($i=0; $i<count($this->bcc); $i++) {
            $data .= "Bcc: " . $this->convertEncodingAddress($this->bcc[$i][0], $this->bcc[$i][1]) . $this->eol;
        }
        $data .= "Reply-To: " . $this->reply_to . $this->eol;
        $data .= "X-Mailer: " . $this->x_mailer . $this->eol;
        $data .= "MIME-Version: " . $this->mime_version . $this->eol;
        foreach ($this->headers as $name => $value) {
            if (is_array($value)) {
                $value = implode(', ', $value);
            }
            $data .= "{$name}: {$value}" . $this->eol;
        }

        switch (count($this->attachments)) {
        case 0:
            break;
        case 1:
            $data .= $this->getAttachmentData($this->attachments[0], $body_escape);
            break;
        default:
            $data .= "Content-Type: multipart/mixed; boundary=\"$boundary\"" . $this->eol;
            $data .= $this->eol;
            for ($i=0; $i<count($this->attachments); $i++) {
                $data .= '--' . $boundary . $this->eol;
                $data .= $this->getAttachmentData($this->attachments[$i], $body_escape);
            }
            $data .= '--' . $boundary . "--" . $this->eol;
        }
        return $data;
    }

    /**
     * ᡼å򥻥å
     *
     * @access public
     * @param string ᡼å
     */
    function setMessage($data)
    {
        $datas = explode($this->eol . $this->eol, $data, 2);
        // إåѴ
        $headers = $this->getHeaders($datas[0]);

        // ᡼륨󥳡ǥ󥰼
        if (isset($headers['content-type'])) {
            if (preg_match('/charset="?([^"]+)"?/is', $headers['content-type'][0], $matches)) {
                $this->mail_encode = trim($matches[1]);
            }
        }

        // ᡼إå
        foreach ($headers as $name => $header) {
            switch ($name) {
            case 'from':     $this->from     = $this->convertDecodingAddress($header[0]); break;
            case 'to':       $this->to[]     = $this->convertDecodingAddress($header[0]); break;
            case 'reply-to': $this->reply_to = $this->convertDecodingAddress($header[0]); break;
            case 'subject':  $this->subject  = $this->convertDecoding($header[0], true);  break;
            case 'date':       $this->headers['Date']       = $header[0]; break;
            case 'message-id': $this->headers['Message-ID'] = $header[0]; break;
            case 'mime-version': $this->mime_version = $header[0]; break;
            case 'x-mailer':     $this->x_mailer     = $header[0]; break;
            case 'content-transfer-encoding':
                switch ($header[0]) {
                case 'base64':           $this->transfer_encoding = 'B'; break;
                case 'quoted-printable': $this->transfer_encoding = 'Q'; break;
                }
                break;
            }
        }

        // å
        if (isset($datas[1])) {
            if (!isset($headers['content-type']) || (strpos($headers['content-type'][0], 'text/') !== false)) {
                // ƥȥѡ
                $this->attachments[] = array(
                  'body'              => $datas[1],
                  'type'              => $headers['content-type'][0],
                  'transfer_encoding' => isset($headers['content-transfer-encoding'][0]) ? $headers['content-transfer-encoding'][0] : ''
                );
            } else if (strpos($headers['content-type'][0], 'multipart/') !== false) {
                // ޥѡ
                if (preg_match('/boundary="?([^"]+)"? ?/', $headers['content-type'][0], $matches)) {
                    $boundary = "--{$matches[1]}";
                    // ޥѡȤνλʲ
                    $pos = strpos($datas[1], "{$this->eol}{$boundary}--{$this->eol}");
                    if ($pos !== false) {
                        $datas[1] = substr($datas[1], 0, $pos);
                    }
                    // ޥѡʬ
                    $messages = explode("{$this->eol}{$boundary}{$this->eol}", $datas[1]);

                    // Ƭʬ
                    array_shift($messages);
                    foreach ($messages as $message) {
                        $messages2 = explode($this->eol . $this->eol, $message, 2);
                        switch (count($messages2)) {
                        case 2:
                            // إå
                            $headers_sub = $this->getHeaders($messages2[0]);
                            if (isset($headers_sub['content-type'])) {
                                if (preg_match('/charset="?([^"]+)"?/is', $headers_sub['content-type'][0], $matches)) {
                                    $this->mail_encode = trim($matches[1]);
                                }
                            }
                            $this->transfer_encoding = '7bit';
                            if (isset($headers_sub['content-transfer-encoding'])) {
                                switch ($headers_sub['content-transfer-encoding'][0]) {
                                case 'base64':
                                    $this->transfer_encoding = 'B';
                                    $messages2[1] = base64_decode($messages2[1]);
                                    break;
                                }
                            }
                            $filename = null;
                            if (isset($headers_sub['content-disposition'])) {
                                if (preg_match('/filename="?([^"]+)"?/is', $headers_sub['content-disposition'][0], $matches)) {
                                    $filename = $this->convertDecoding(trim($matches[1]), true);
                                }
                            }

                            if ($this->transfer_encoding == '7bit') {
                                // ƥȷ
                                $this->attachments[] = array(
                                  'body'              => $this->convertDecoding($messages2[1]),
                                  'type'              => isset($headers_sub['content-type'][0]) ? $headers_sub['content-type'][0] : '',
                                  'transfer_encoding' => isset($headers_sub['content-transfer-encoding'][0]) ? $headers_sub['content-transfer-encoding'][0] : '',
                                  'name'              => null,
                                  'file'              => null
                                );
                            } else {
                                // ¾źշ
                                $this->attachments[] = array(
                                  'body'              => null,
                                  'type'              => isset($headers_sub['content-type'][0]) ? $headers_sub['content-type'][0] : '',
                                  'transfer_encoding' => isset($headers_sub['content-transfer-encoding'][0]) ? $headers_sub['content-transfer-encoding'][0] : '',
                                  'name'              => $filename,
                                  'file'              => $messages2[1]
                                );
                            }
                            break;
                        case 1:
                            // إåʤŪʸ
                            $this->attachments[] = array(
                              'body'              => $messages2[0],
                              'type'              => null,
                              'transfer_encoding' => null,
                              'name'              => null,
                              'file'              => null
                            );
                            break;
                        }
                    }
                }
            }
        }
    }

    /**
     * ʸźǡ
     *
     * @access private
     * @param array ǡ
     * @param bool SMTPʸ
     * @return string ʸźǡ
     */
    function getAttachmentData(&$attachment, $body_escape)
    {
        $data  = '';
        $data .= "Content-Type: {$attachment['type']}" . $this->eol;
        $data .= "Content-Transfer-Encoding: {$attachment['transfer_encoding']}" . $this->eol;
        if (isset($attachment['body'])) {
            // ƥ
            $body = $body_escape ? preg_replace('/(\r\n|\n|\r)\.(\r\n|\n|\r)/s', '$1..$2', $attachment['body']) : $attachment['body'];
            $data .= $this->eol;
            $data .= $this->convertEncoding($body) . $this->eol;
        } else {
            // ź
            $data .= "Content-Disposition: attachment; filename=\"{$attachment['name']}\"" . $this->eol;
            $data .= $this->eol;
            $data .= $attachment['file'] . $this->eol;
        }
        return $data;
    }

    /**
     * ᡼إåȤƼ
     * إåΥϤ٤ƾʸˤʤ
     *
     * @access private
     * @param string ᡼إå
     * @return array ᡼إå
     */
    function getHeaders($header)
    {
        $tmp = '';
        $headers = array();
        foreach (explode($this->eol, $header) as $line) {
            if (preg_match('/^[ |\t]/', $line, $matches)) {
                $tmp .= $this->eol . $line;
            } else {
                if ($tmp) {
                    if (preg_match('/^([^\:]+)\:(.+)$/is', $tmp, $matches)) {
                        $headers[strtolower($matches[1])][] = trim($matches[2]);
                    }
                }
                $tmp = $line;
            }
        }
        if ($tmp) {
            if (preg_match('/^([^\:]+)\:(.+)$/is', $tmp, $matches)) {
                $headers[strtolower($matches[1])][] = trim($matches[2]);
            }
        }
        return $headers;
    }
}

?>
