<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketCatalogSearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹ʳŷ - ŷAPIѡ
 */
require_once 'SyL_WebServiceMarketCatalogSearchResponse.php';

/**
 * WEBӥ饹ʳŷ - ŷAPIѡ
 *
 * ܺ٤ϡŷ֥ӥ󥿡
 *   http://webservice.rakuten.co.jp/
 * ŷAPI 
 *   http://webservice.rakuten.co.jp/api/catalogsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketCatalogSearchRequest.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceMarketCatalogSearchRequest extends SyL_WebServiceRakuten_co_jpRequest
{
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/rws/1.11/rest';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceMarketCatalogSearchResponse';

    /**
     * ɤ򥻥åȤ
     *
     * @access public
     * @param string 
     */
    function setKeyword($keyword)
    {
        parent::set('keyword', $keyword);
    }

    /**
     * С򥻥åȤ
     *
     * @access public
     * @param string С
     */
    function setVersion($version)
    {
        parent::set('version', $version);
    }

    /**
     * ID򥻥åȤ
     *
     * @access public
     * @param int ID
     */
    function setGenreId($genreId)
    {
        if (preg_match('/^\d+$/', $genreId)) {
            parent::set('genreId', $genreId);
        } else {
            trigger_error("[SyL error] Invalid `genreId' property ({$genreId}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 1ڡμ򥻥åȤ
     *
     * @access public
     * @param int 1ڡμ
     */
    function setHits($hits)
    {
        if (preg_match('/^\d+$/', $hits) && (($hits >= 1) && ($hits <= 30))) {
            parent::set('hits', $hits);
        } else {
            trigger_error("[SyL error] Invalid `hits' property ({$hits}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ڡ򥻥åȤ
     *
     * @access public
     * @param int ڡ
     */
    function setPage($page)
    {
        if (preg_match('/^\d+$/', $page) && (($page >= 1) && ($page <= 100))) {
            parent::set('page', $page);
        } else {
            trigger_error("[SyL error] Invalid `page' property ({$page}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Ȥ򥻥åȤ
     *
     * @access public
     * @param string 
     */
    function setSort($sort)
    {
        switch ($sort) {
        case '+registerDate':
        case '-registerDate':
        case '+releaseDate':
        case '-releaseDate':
        case '+reviewNum':
        case '-reviewNum':
        case 'random':
            parent::set('sort', $sort);
            break;
        default:
            trigger_error("[SyL error] Invalid `sort' property ({$sort}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * եɤ򥻥åȤ
     *
     * @access public
     * @param int ե
     */
    function setField($field)
    {
        switch ((string)$field) {
        case '0':
        case '1':
            parent::set('field', $field);
            break;
        default:
            trigger_error("[SyL error] Invalid `field' property ({$field}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ʲ̵ͭե饰򥻥åȤ
     *
     * @access public
     * @param int ʲ̵ͭե饰
     */
    function setImageFlag($imageFlag)
    {
        switch ((string)$imageFlag) {
        case '0':
        case '1':
            parent::set('imageFlag', $imageFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `imageFlag' property ({$imageFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ȯ򥻥åȤ
     *
     * @access public
     * @param int ȯ
     */
    function setReleaseRange($releaseRange)
    {
       if (preg_match('/^\d+$/', $releaseRange) && (($releaseRange >= 0) && ($releaseRange <= 12))) {
            parent::set('releaseRange', $releaseRange);
        } else {
            trigger_error("[SyL error] Invalid `releaseRange' property ({$releaseRange}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ORե饰򥻥åȤ
     *
     * @access public
     * @param int ORե饰
     */
    function setOrFlag($orFlag)
    {
        switch ((string)$orFlag) {
        case '0':
        case '1':
            parent::set('orFlag', $orFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `orFlag' property ({$orFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ɤ򥻥åȤ
     *
     * @access public
     * @param string 
     */
    function setNGKeyword($NGKeyword)
    {
        parent::set('NGKeyword', $NGKeyword);
    }

    /**
     * 뤴Ȥξʿե饰򥻥åȤ
     *
     * @access public
     * @param int 뤴Ȥξʿե饰
     */
    function setGenreInformationFlag($genreInformationFlag)
    {
        switch ((string)$genreInformationFlag) {
        case '0':
        case '1':
            parent::set('genreInformationFlag', $genreInformationFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `genreInformationFlag' property ({$genreInformationFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
