<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMusicStationResponse.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ɥơȥꥹѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ɥơȥꥹ
 *   http://developer.yahoo.co.jp/music/station/v1/programlist.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMusicStationResponse.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceMusicStationResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ȷ
     *
     * @access private
     * @var int
     */
     var $count = 0;
    /**
     * Ȥ˴ؤ
     *
     * @access private
     * @var array
     */
    var $items = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $item_i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        // ȷ
        case '/ProgramResult/Program/Count': $this->count = $text; break;

        // Ȥ˴ؤ
        case '/ProgramResult/Program/Item':  $item_i++; break;
        // ͥ륫ƥ
        case '/ProgramResult/Program/Item/Category': $this->items[$item_i]['Category'] = $text; break;
        // ͥ̾
        case '/ProgramResult/Program/Item/ChannelName': $this->items[$item_i]['ChannelName'] = $text; break;
        // ̾
        case '/ProgramResult/Program/Item/ProgramName': $this->items[$item_i]['ProgramName'] = $text; break;
        // ͥڡURL
        case '/ProgramResult/Program/Item/ChannelURL': $this->items[$item_i]['ChannelURL'] = $text; break;
        // ȥץ졼䡼ưURL
        case '/ProgramResult/Program/Item/ProgramURL': $this->items[$item_i]['ProgramURL'] = $text; break;
        // 쥳ɥͥʲȤξֺǽ(YYYYMMDD)
        case '/ProgramResult/Program/Item/ProgramLastUpdate': $this->items[$item_i]['ProgramLastUpdate'] = $text; break;
        // ָȤξָλ(YYYYMMDD)
        case '/ProgramResult/Program/Item/ProgramEnd': $this->items[$item_i]['ProgramEnd'] = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ȷ
     *
     * @access public
     * @return int ȷ
     */
    function getCount()
    {
        return $this->count;
    }

    /**
     * Ȥ˴ؤ
     *
     * @access public
     * @return array Ȥ˴ؤ
     */
    function getItems()
    {
        return $this->items;
    }
}

?>
