<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ContextJs.php,v 1.13 2008/11/09 10:05:35 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ꥯȥ饹
 */
require_once SYL_INCLUDE_DIR . '/framework/SyL_Request.php';

/**
 * JavaScriptϥե졼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ContextJs.php,v 1.13 2008/11/09 10:05:35 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ContextJs extends SyL_Context
{
    /**
     * ӥ塼
     * 
     * @access protected
     * @var string
     */
    var $view_type = 'js.default';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param object ǡ֥
     */
    function SyL_ContextJs(&$data)
    {
        // JSݡȽ
        if ($data->getImport()) {
            $this->is_execute = false;
        }
        parent::SyL_Context($data);
    }

    /**
     * ꥯȥ֥Ȥ
     *
     * @access public
     * @return object ꥯȥ֥
     */
    function &getRequest()
    {
        return SyL_Request::singleton();
    }

    /**
     * ĶѿGETꥯȤȽꤹ
     *
     * @access public
     * @return bool true: GETꥯȡfalse: GETꥯȰʳ
     */
    function isGet()
    {
        return (isset($_SERVER['REQUEST_METHOD']) && ($_SERVER['REQUEST_METHOD'] == 'GET'));
    }

    /**
     * ĶѿPOSTꥯȤȽꤹ
     *
     * @access public
     * @return bool true: POSTꥯȡfalse: POSTꥯȰʳ
     */
    function isPost()
    {
        return (isset($_SERVER['REQUEST_METHOD']) && ($_SERVER['REQUEST_METHOD'] == 'POST'));
    }

    /**
     * ĶѿSSLȽꤹ
     *
     * @access public
     * @return bool true: POSTꥯȡfalse: POSTꥯȰʳ
     */
    function isSsl()
    {
        return (isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] == 'on'));
    }

    /**
     * Ķѿ饵С̾
     *
     * @access public
     * @return string С̾
     */
    function getServerName()
    {
        if (isset($_SERVER['HTTP_HOST'])) {
            return $_SERVER['HTTP_HOST'];
        } else if (isset($_SERVER['SERVER_NAME'])) {
            if (isset($_SERVER['SERVER_PORT']) && ($_SERVER['SERVER_PORT'] != '80')) {
                return $_SERVER['SERVER_NAME'] . ':' . $_SERVER['SERVER_PORT'];
            } else {
                return $_SERVER['SERVER_NAME'];
            }
        } else {
            return null;
        }
    }

    /**
     * ĶѿꥯURLSCRIPT_NAMEˤ
     *
     * @access public
     * @return string SCRIPT_NAME
     */
    function getScriptName()
    {
        $request_uri = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '';
        $script_name = isset($_SERVER['SCRIPT_NAME']) ? $_SERVER['SCRIPT_NAME'] : '';
        if ($request_uri && $script_name) {
            if (preg_match ('/^' . preg_quote($script_name, '/') . '/', $request_uri)) {
                return $script_name;
            } else {
                // ĥҤ̵б
                $path_parts = pathinfo($script_name);
                if (isset($path_parts['extension'])) {
                    $path_parts['basename'] = basename($script_name, '.' . $path_parts['extension']);
                }
                if ($path_parts['dirname'] == '/') {
                    $path_parts['dirname'] = '';
                }
                return $path_parts['dirname'] . '/' . $path_parts['basename'];
            }
        } else {
            return null;
        }
    }

    /**
     * ĶѿꥯURLPHP_SELFˤ
     *
     * @access public
     * @return string PHP_SELF
     */
    function getPhpSelf()
    {
        return isset($_SERVER['PHP_SELF']) ? $_SERVER['PHP_SELF'] : null;
    }

    /**
     * ĶѿꥯURLREQUEST_URIˤ
     *
     * @access public
     * @return string PHP_SELF
     */
    function getRequestUri()
    {
        return isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : null;
    }

    /**
     * ĶѿPATHINFO
     *
     * @access public
     * @return string PATHINFO
     */
    function getPathInfo()
    {
        return isset($_SERVER['PATH_INFO']) ? $_SERVER['PATH_INFO'] : null;
    }

    /**
     * PATH_INFOγURLȤƼ
     *
     * @access protected
     * @param object ƥȥ֥
     * @return array PATH_INFOγURL
     */
    function getUrlNames()
    {
        $pathinfo = $this->getPathInfo();
        if (substr($pathinfo, -1) == '/') {
            $pathinfo = substr($pathinfo, 0, -1);
        } else {
            $pathinfo = dirname($pathinfo);
        }
        // ǥ쥯ȥ
        $urls = substr($pathinfo, 1); // Ƭ/׺
        return (($urls !== false) && ($urls !== '')) ? explode('/', $urls) : array();
    }
}

?>
