<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Config.php,v 1.22 2008/11/09 10:05:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * XML饹
 */
require_once SYL_INCLUDE_DIR . '/lib/Xml/SyL_XmlReader.php';
/**
 * å奯饹
 */
require_once SYL_INCLUDE_DIR . '/lib/SyL_Cache.php';

/** 
 * եɤ߹९饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Config.php,v 1.22 2008/11/09 10:05:34 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Config extends SyL_XmlReader
{
    /**
     * ե̾
     * 
     * @access private
     * @var string
     */
    var $config_file_name = '';
    /**
     * ٥̾
     * 
     * @access protected
     * @var string
     */
    var $event = '';
    /**
     * ǥեȼ¹Խ
     * 
     * @access protected
     * @var int
     */
    var $default_priority = 5;
    /**
     * XMLե̾
     * 
     * @access private
     * @var array
     */
    var $file_names = array();
    /**
     * ե
     * 
     * @access private
     * @var array
     */
    var $config = array();
    /**
     * 롼֥
     * 
     * @access private
     * @var object
     */
    var $router = null;

    /**
     * 󥹥ȥ饯
     *
     * @access public
     */
    function SyL_Config()
    {
        $this->setProjectConfigFiles();
    }

    /**
     * ե򥻥å
     *
     * @access protected
     */
    function setProjectConfigFiles()
    {
    }

    /**
     * ե륪֥Ȥ
     *
     * @static
     * @access public
     * @param string ե륪֥̾
     * @return object ե륪֥
     */
    function &factory($config_name)
    {
        $class_name = 'SyL_Config' . ucfirst($config_name);
        include_once SYL_INCLUDE_DIR . "/framework/Config/{$class_name}.php";
        $obj = new $class_name();
        return $obj;
    }

    /**
     * 롼֥Ȥ򥻥å
     *
     * @access public
     * @param object 롼֥
     */
    function setRouter(&$router)
    {
        $this->router =& $router;
    }

    /**
     * ͤ
     *
     * @static
     * @access public
     * @param string ꥭ
     */
    function get($name='')
    {
        static $values = null;

        if ($values !== null) {
            if ($name === '') {
                return $values;
            } else {
                return isset($values[$name]) ? $values[$name] : null;
            }
        } else {
            $config =& SyL_Config::factory('defines');
            $config->parseXml();
            $values = $config->getConfig();
        }
    }

    /**
     * å奪֥Ȥ
     *
     * @access public
     * @param string åƬ
     * @param string ɲåʸ
     * @return object å奪֥
     */
    function &getCache($key)
    {
        // åѤ
        $mtime = 0;
        foreach ($this->file_names as $file_name) {
            $mtime_tmp = filemtime($file_name);
            if ($mtime < $mtime_tmp) {
                $mtime = $mtime_tmp;
            }
        }

        $cache =& SyL_Cache::factory('file');
        $cache->setPrefix(SYL_APP_NAME . '.');
        $cache->setKey($key);
        $cache->setMinModifyTime($mtime);
        $cache->setCacheDir(SYL_CACHE_FILE_DIR . '/config/' . basename($this->file_names[0]) . '/');

        //$cache->useIncludeCache();

        $this->config = $cache->read();
        if ($this->config) {
            // åOK
            $cache = null;
            return $cache;
        } else {
            // åNG
            return $cache;
        }
    }

    /**
     * ʣXMLեϤ
     *
     * @access public
     * @param bool åͭե饰
     */
    function parseXml($enable_cache=true)
    {
        $config = array();
        foreach ($this->file_names as $file_name) {
            parent::setFile($file_name);
            parent::parseXml();
            if (is_array($this->config)) {
                $config += $this->config;
            }
            // 
            $this->config = array();
        }
        $this->config = $config;
    }

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
    }

    /**
     * XMLͤ
     * 
     * @access public
     * @return array 
     */
    function getConfig()
    {
        return $this->config;
    }
}

?>
