<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Logger.php,v 1.17 2008/07/27 14:53:10 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ϥ饹
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Logger.php,v 1.17 2008/07/27 14:53:10 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Logger
{
    /**
     * ¨ϥե饰
     * 
     * @access protected
     * @var bool
     */
    var $immediate = true;
    /**
     * ¨ϤǤϤʤ˳ǼХåե
     * 
     * @access protected
     * @var array
     */
    var $buffer = array();
    /**
     * եեޥå
     * dateեޥå
     * 
     * @access protected
     * @var string
     */
    var $datetime_format = 'Y-m-d H:i:s';
    /**
     * ԥ
     * 
     * @access protected
     * @var string
     */
    var $eol = "\r\n";

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param boolean ¨ϥե饰 true: ¨ϡfalse: ꥯȽλ˽
     */
    function SyL_Logger($immediate=true)
    {
        $this->immediate = $immediate;
    }

    /**
     * ֥Ȥμ
     *
     * @access public
     * @param string ƥ̾
     * @param boolean ¨ϥե饰 true: ¨ϡfalse: ꥯȽλ˽
     * @return object ֥
     */
    function &getLogger($type='', $immediate=true)
    {
        $logger_object = null;
        if ($type) {
            $classname = 'SyL_Logger' . ucfirst($type);
            include_once SYL_INCLUDE_DIR . "/framework/Logger/{$classname}.php";
        } else {
            $classname = 'SyL_Logger';
        }
        $logger_object =& new $classname($immediate);
        return $logger_object;
    }

    /**
     * ץ
     *
     * @access public
     */
    function open()
    {
    }

    /**
     * ν
     *
     * @access public
     * @param string ٥̾
     * @param string å
     */
    function log($level, $message)
    {
    }

    /**
     * 
     *
     * @access public
     */
    function logAll()
    {
        if (!$this->immediate) {
            while (true) {
                $buffer = array_shift($this->buffer);
                if (!$buffer) {
                    break;
                }
                $this->log('', $buffer);
            }
        }
    }

    /**
     * Ĥ
     *
     * @access public
     */
    function close()
    {
        $this->logAll();
    }

    /**
     * 󥰤Ƥ륯饹᥽åɤ
     *
     * @access protected
     * @return string 󥰤Ƥ륯饹᥽å
     */
    function getLoggingClass()
    {
        $funcname = '';
        $match    = false;
        foreach (debug_backtrace() as $debug) {
            if (isset($debug['class']) && isset($debug['function'])) {
                if (preg_match('/^SyL_(Logger|Error)/i', $debug['class']) ||
                    preg_match('/^(raiseEvent|errorStream)$/i', $debug['function'])) {
                    $match = true;
                } else {
                    $type = isset($debug['type']) ? $debug['type'] : '.';
                    $funcname = $debug['class'] . $type . $debug['function'] . '()';
                    if ($match) {
                        break;
                    }
                }
            }
        }
        return $funcname;
    }
}

?>
