<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Router.php,v 1.23 2008/11/09 10:05:35 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ܾ󥯥饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Router.php,v 1.23 2008/11/09 10:05:35 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_Router
{
    /**
     * ǥեȥե̾
     * Ƭʸ
     *
     * @access protected
     * @var string
     */
    var $action_file_default = 'Index.php';
    /**
     * URLγĥ
     *
     * @access protected
     * @var string
     */
    var $url_ext = SYL_ROUTER_URL_EXT;
    /**
     * ¹ԥեγĥ
     *
     * @access protected
     * @var string
     */
    var $exe_ext = '.php';
    /**
     * ǥ쥯ȥ롼
     *
     * @access private
     * @var string
     */
    var $action_dir = '';
    /**
     * ƥץ졼ȥǥ쥯ȥ롼
     *
     * @access private
     * @var string
     */
    var $template_dir = '';
    /**
     * ե
     *
     * @access protected
     * @var string
     */
    var $action_file = '';
    /**
     * ƥץ졼ȥե
     *
     * @access protected
     * @var string
     */
    var $template_file = '';
    /**
     * ᥽å̾
     *
     * @access protected
     * @var string
     */
    var $action_method = '';
    /**
     * ӥ塼
     *
     * @access protected
     * @var string
     */
    var $view_type = '';
    /**
     * 쥤̾
     *
     * @access protected
     * @var string
     */
    var $layout_name = '';

    /**
     * 󥹥ȥ饯
     *
     * @access public
     * @param string 
     */
    function SyL_Router()
    {
        // ǥ쥯ȥ
        $this->action_dir = SYL_APP_DIR . '/actions/';
        // ƥץ졼ȥǥ쥯ȥ
        $this->template_dir = SYL_APP_DIR . '/templates/';
    }

    /**
     * ܾ󥪥֥Ȥ
     *
     * @static
     * @access public
     * @param object ǡ֥
     * @return object ܾ󥪥֥
     */
    function &factory(&$data)
    {
        $classname = 'SyL_Router' . ucfirst(SYL_ROUTER_RULE);
        include_once SYL_INCLUDE_DIR . "/framework/Router/{$classname}.php";
        $router = new $classname();
        // եѥå
        if (!$router->validAction()) {
            SyL_Response::forwardFileNotFound();
        }
        $router->createActionInfo($data);
        $router->changeRoutingConfig();
        return $router;
    }

    /**
     * ܾ󥪥֥ȤΥץѥƥ
     *
     * $this->action_method
     * $this->action_file
     * $this->action_class
     *
     * @access abstract
     * @param object ǡ֥
     */
    function createActionInfo(&$data)
    {
    }

    /**
     * ǥ쥯ȥ롼Ȥ
     *
     * @access public
     * @return string ǥ쥯ȥ롼
     */
    function getActionDir()
    {
        return $this->action_dir;
    }

    /**
     * ƥץ졼ȥǥ쥯ȥ롼Ȥ
     *
     * @access public
     * @return string ƥץ졼ȥǥ쥯ȥ롼
     */
    function getTemplateDir()
    {
        return $this->template_dir;
    }

    /**
     * ե򥻥å
     *
     * @access public
     * @param string ե
     */
    function setActionFile($action_file)
    {
        if ($action_file[0] == '/') {
            $action_file = substr($action_file, 1);
        }
        $this->action_file = $action_file;
    }

    /**
     * ե
     *
     * @access public
     * @return string ե
     */
    function getActionFile()
    {
        return $this->action_file;
    }

    /**
     * ƥץ졼ȥե򥻥å
     *
     * @access public
     * @param string ƥץ졼ȥե
     */
    function setTemplateFile($template_file)
    {
        if ($template_file[0] == '/') {
            $template_file = substr($template_file, 1);
        }
        $this->template_file = $template_file;
    }

    /**
     * ƥץ졼ȥե
     *
     * @access public
     * @param bool 404顼ưե饰
     * @return string ƥץ졼ȥե
     */
    function getTemplateFile($trigger_error_404=true)
    {
        // ƥץ졼ȥե¸ߥå
        if ($trigger_error_404 && !is_file($this->getTemplateDir() . $this->template_file)) {
            SyL_Loggers::warn("Template file not found dir: {$template_dir} file: {$template_file}");
            SyL_Response::forwardFileNotFound();
        }
        return $this->template_file;
    }

    /**
     * 饹̾
     *
     * @access public
     * @return string 饹̾
     */
    function getClassName()
    {
        return $this->createActionClass();
    }

    /**
     * ᥽å̾
     *
     * @access public
     * @return string ̾
     */
    function getActionName()
    {
        return $this->action_method;
    }

    /**
     * ӥ塼פ򥻥å
     *
     * @access public
     * @param string ӥ塼
     */
    function setViewType($view_type)
    {
        $this->view_type = $view_type;
    }

    /**
     * ӥ塼פ
     *
     * @access public
     * @return string ӥ塼
     */
    function getViewType()
    {
        return $this->view_type;
    }

    /**
     * 쥤̾
     *
     * @access public
     * @return string 쥤̾
     */
    function getLayoutName()
    {
        return $this->layout_name;
    }

    /**
     * 󥯥饹̾
     *
     * @access protected
     * @return string 󥯥饹̾
     */
    function createActionClass()
    {
        $classname = str_replace('/', '_', $this->action_file);
        return preg_replace('/(' . preg_quote($this->exe_ext) . ')$/', '', $classname);
    }

    /**
     * 롼ƥŬ
     *
     * @access public
     */
    function changeRoutingConfig()
    {
        $config =& SyL_Config::factory('routers');
        $config->setRouter($this);
        $config->parseXml();
        $router = $config->getConfig();
        if ($router) {
            if ($router['enableAction'] && $router['forwardAction']) {
                $this->setActionFile($router['forwardAction']);
            }
            if ($router['enableTemplate'] && $router['forwardTemplate']) {
                $this->setTemplateFile($router['forwardTemplate']);
            }
            if ($router['viewType'])   $this->view_type   = $router['viewType'];
            if ($router['layoutName']) $this->layout_name = $router['layoutName'];
        }
    }

    /**
     * եΥѥå
     * ǥ쥯ȥ꡿եƬ_פϥԲ
     *
     * @access public
     * @return bool true: ͭfalse: ̵
     */
    function validAction()
    {
        foreach (explode('/', $this->action_file) as $tmp) {
            if ($tmp && ($tmp[0] == '_')) {
                return false;
            }
        }
        return true;
    }
}

?>
