<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJsonp.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * JSONPӥ塼饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ViewJsonp.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_ViewJsonp extends SyL_View
{
    /**
     * ϥ󥰼¹
     * 
     * @access public
     */
    function render()
    {
        // JSХåؿ
        $callback = $this->data->getJsCallback();
        $values =& $this->getActionValues();
        // ѥ᡼ϡJson֥Ȥ򥻥å
        if (!function_exists('json_encode')) {
            include_once SYL_INCLUDE_DIR . '/lib/Util/SyL_UtilJson.php';
        }
        if ($this->context->isPost()) {
            // ƥĥפ򥻥å
            $this->setContentType('text/html; charset=' . SYL_ENCODE_JS);

            // iframe ˽
            if ($callback) {
                $javascript = $callback . '(' . json_encode($values) . ')';
                $javascript = '<html><head><script type="text/javascript">if (parent.window) {parent.window.' . $javascript . ';} else {' . $javascript . ';}</script></head><html>';
            } else {
                $javascript = '<html><head><script type="text/javascript">alert("JSONP callback parameter not found");</script></head><html>';
            }
        } else {
            // ƥĥפ򥻥å
            $this->setContentType('application/x-javascript; charset=' . SYL_ENCODE_JS);

            // script ˽
            if ($callback) {
                $javascript = $callback . '(' . json_encode($values) . ');';
            } else {
                $javascript = 'alert("JSONP callback parameter not found");';
            }
        }
        // JavaScirpt
        $this->setRender($javascript);
    }
}

?>
