<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDriverPdomysql.php,v 1.6 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DB饹PDO
 */
require_once dirname(__FILE__) . '/../SyL_DBPdo.php';

/**
 *  DB饹PDO::Mysql
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBDriverPdomysql.php,v 1.6 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_DBDriverPdomysql extends SyL_DBPdo
{
    /**
     * MySQLΥС4.1ʾ
     *
     * @access private
     * @vat bool
     */
     private $ismore41 = false;

    /**
     * 󥳡Ѵơ֥
     *
     *  MySQL    <=> PHP
     *  (client)     (client)
     * 
     * ƾʸǵ
     *
     * @access protected
     * @var string
     */
    public $encode_table = array(
      // PHP, DB
      array('eucjp-win', 'ujis'),
      array('euc-jp',    'ujis'),
      array('euc',       'ujis'),
      array('sjis-win',  'sjis' ),
      array('sjis',      'sjis'),
      array('utf-8',     'utf8')
    );

    /**
     * DB³¹
     * 
     * @access public
     * @param string ǡ١̾
     * @param string 桼̾
     * @param string ѥ
     * @param string ۥ̾
     * @param string ݡֹ
     * @param bool ³Ū³Ԥ
     * @return boolean ³OK: true, ³NG: false
     */
    public function openConnection($dbname, $user, $passwd, $host, $port, $persistent)
    {
        $conn_dbtype  = substr($this->dbtype, 3);
        $conn_strings = array();
        $conn_user    = null;
        $conn_passwd  = null;
        if ($dbname) $conn_strings[] = 'dbname=' . $dbname;
        if ($host) $conn_strings[]   = 'host='   . $host;
        if ($port) $conn_strings[]   = 'port='   . $port;
        if ($user && $passwd) {
            $conn_user   = $user;
            $conn_passwd = $passwd;
        } else if ($user) {
            $conn_user = $user;
        }

        $conn_string = $conn_dbtype . ':' . implode(';', $conn_strings);
        if ($this->pdoConnection($conn_string, $conn_user, $conn_passwd)) {
            $this->ismore41 = version_compare($this->getVersion(), '4.1.0', '>=');
            return true;
        } else {
            return false;
        }
    }

    /**
     * 饤¦ʸ󥳡ƥ
     * 
     * @access public
     * @param string DBʸ
     * @param string PHP¦󥳡
     */
    public function setClientEncoding($client_encode, $server_encode='')
    {
        if ($this->ismore41) {
            $client_encode2 = strtolower($client_encode);
            foreach ($this->encode_table as $encode_table) {
                if ($encode_table[0] == $client_encode2) {
                    $client_encode2 = $encode_table[1];
                    break;
                }
            }
            $this->connection->exec("SET NAMES {$client_encode2}");
        }
        parent::setClientEncoding($client_encode, $server_encode);
    }

    /**
     * SQL¹Ԥ̼
     * 
     * SQLʸselectξ
     *   ¹Է̤꥽ȤƼ
     * SQLʸinsert, update, deleteξ
     *   ¹Է̱ƶ
     * SQLʸ嵭ʳξ
     *   ¹Ը塢true or falseֵ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed ¹Է̷ޤDB꥽
     * @return boolean ¹OK: true, ¹NG: false
     */
    public function execRef($sql, &$result)
    {
        if (!$this->ismore41) {
            $this->convertEncoding($sql);
        }
        return parent::execRef($sql, $result);
    }

    /**
     * SQL¹Ԥ̥ǡ
     *
     * 3ѥ᡼'one'ξ
     *    ǽ1ʸȤƼ
     * 3ѥ᡼'record'ξ
     *    ǽ1쥳ɤȤƼ
     * 3ѥ᡼'all'ξ
     *    쥳ɤȤƼ
     *
     * @access public
     * @param string SQLʸ
     * @param mixed  ¹Է̤
     * @param string ̼ե饰
     * @return boolean ¹OK: true, ¹NG: false
     */
    public function queryRef($sql, &$data, $get='all')
    {
        if (parent::queryRef($sql, $data, $get)) {
            if (!$this->ismore41) {
                $this->convertDecoding($data);
            }
            return true;
        } else {
            return false;
        }
    }

    /**
     * SQL¹Ԥڡ˥ǡ
     *
     * @access public
     * @param string SQLʸ
     * @param array ¹Է̳Ǽ
     * @param object ڡ֥
     * @param int 1ڡɽ
     * @param int ɽоݥڡ 
     * @return bool ¹Է
     */
    public function queryPageRef($sql, &$result, &$pager, $limit=20, $page=1)
    {
        // ڡ󥰥֥
        $pager = $this->getPager($limit, $page);
        // SQL
        if ($this->ismore41) {
            $sql_count = "SELECT COUNT(*) FROM (" . $sql . ") AS SyL$";
        } else {
            if (preg_match('/^select (.+) from (.+)$/i', $sql, $matches)) {
                $sql_count = "SELECT COUNT(*) FROM {$matches[2]}";
            } else {
                trigger_error("[SyL error] Invalid select SQL ({$sql})", E_USER_ERROR);
            }
        }
        // SQL¹
        if (!$this->queryRef($sql_count, $record, 'one')) return false;
        $pager->setCountAll($record);

        // ڡñ̥쥳ɼ
        $sql_page  = $sql;
        $sql_page .= ' LIMIT ' . $pager->getStartOffset() . ', ' . $pager->getCount();

        // ǡSQL¹
        return $this->queryRef($sql_page, $result, 'all');
    }

    /**
     * ³ƤDBСΥС
     * 
     * @access public
     * @return string DBΥС
     */
    public function getVersion()
    {
        $sql = "SELECT VERSION()";
        $this->queryRef($sql, $version, 'one');
        list($version) = explode('-', $version);
        return $version;
    }
}

?>
