<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilesystemDirectory.php,v 1.4 2008/09/23 09:06:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ե륷ƥΥǥ쥯ȥꥯ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilesystemDirectory.php,v 1.4 2008/09/23 09:06:15 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_FilesystemDirectory extends SyL_Filesystem
{
    /**
     * Ǥ
     *
     * @access private
     * @var array
     */
    var $elements = array();
    /**
     * ȤΥȹ̾
     *
     * @access private
     * @var string
     */
    var $sort = '';
    /**
     * ȤΥȽ
     *
     * @access private
     * @var bool
     */
    var $asc = true;

    /**
     * ǥ쥯ȥȽ
     *
     * @access public
     * @return bool true: ǥ쥯ȥꡢfalse: ǥ쥯ȥʳ
     */
    function isDir()
    {
        return true;
    }

    /**
     * ǥꥹȤ
     *
     * @access public
     * @param string ̾ name, size, mtime, owner
     * @param bool Ƚ true: 硢false: ߽
     * @return array ǥ֥ȡʤ
     */
    function getList($sort='name', $asc=true)
    {
        $dirs  = array();
        $files = array();
        foreach (array_keys($this->elements) as $i) {
            if ($this->elements[$i]->isDir()) {
                $dirs[] =& $this->elements[$i];
            } else {
                $files[] =& $this->elements[$i];
            }
        }

        // ȹ̾å
        $this->sort = $sort;
        // Ƚ祻å
        $this->asc = $asc;
        // ǥ쥯ȥΥ
        usort($dirs, array(&$this, 'sortList'));
        // եΥ
        usort($files, array(&$this, 'sortList'));

        return array_merge($dirs, $files);
    }

    /**
     * ǥꥹȤ
     *
     * @access private
     * @param string ̾ name, size, mtime, owner
     * @param bool Ƚ true: 硢false: ߽
     * @return array ǥ֥ȡʤ
     */
    function sortList($a, $b)
    {
        $result = 0;
        switch ($this->sort) {
        case 'name':
            $result = strcmp($a->getName(), $b->getName());
            break;
        case 'size':
            if (($a->getType() == 'file') && ($b->getType() == 'file')) {
                if ($a->getSize() < $b->getSize()) {
                    $result = -1;
                } else if ($a->getSize() > $b->getSize()) {
                    $result = 1;
                } else {
                    $result = 0;
                }
            }
            break;
        case 'mtime':
            if ($a->getStat('mtime') < $b->getStat('mtime')) {
                $result = -1;
            } else if ($a->getStat('mtime') > $b->getStat('mtime')) {
                $result = 1;
            } else {
                $result = 0;
            }
            break;
        case 'owner':
            $result = strcmp($a->getOwner(), $b->getOwner());
            break;
        }

        if ($this->asc) {
            return $result;
        } else {
            if ($result < 0) {
                return 1;
            } else if ($result > 0) {
                return -1;
            } else {
                return 0;
            }
        }
    }

    /**
     * ǥ쥯ȥ곬ؤ
     *
     * @access public
     * @param int Ԥ糬
     */
    function createTree($limit_depth=1)
    {
        $this->clear();
        if ($dh = opendir($this->file)) {
            while (($name = readdir($dh)) !== false) {
                if (($name != '.') && ($name != '..')) {
                    switch ($this->file) {
                    case '/':
                    case '\\':
                        $name = "/{$name}";
                        break;
                    default:
                        $name = "{$this->file}/{$name}";
                    }
                    $element =& SyL_Filesystem::factory($name);
                    if ($element->isDir()) {
                        if ($limit_depth === null) {
                            $element->createTree(null);
                        } else if ($limit_depth > 1) {
                            $element->createTree($limit_depth - 1);
                        }
                    }
                    $this->add($element);
                }
            }
            closedir($dh);
        }
    }

    /**
     * Ǥο֤
     *
     * @access public
     * @return int Ǥο
     */
    function getLength()
    {
        return count($this->elements);
    }

    /**
     * Ǥɲä
     *
     * @access public
     * @param object ǥ֥
     */
    function add($element)
    {
        $this->elements[] = $element;
    }

    /**
     * Ǿ
     *
     * @access public
     */
    function clear()
    {
        $this->elements = array();
    }

    /**
     * Ǥ¸ߤ뤫å
     *
     * @static
     * @access public 
     * @param string ե̾
     * @return bool true: ¸ߤ롢false: ¸ߤʤ
     */
    function exists($file)
    {
        return is_dir($file);
    }

    /**
     * ǥ쥯ȥ
     *
     * @static
     * @access public 
     * @param string ե̾
     * @return bool true: OKfalse: 顼
     */
    function remove($file)
    {
        $dir =& SyL_Filesystem::factory($file);
        $dir->createTree(2); // 2ؤޤǼ
        foreach ($dir->getList() as $element) {
            if ($element->isDir()) {
               SyL_FilesystemDirectory::remove($element->getName());
            } else {
                SyL_FilesystemFile::remove($element->getName());
            }
        }
        return rmdir($file);
    }

    /**
     * ǥ쥯ȥ
     *
     * @static
     * @access public
     * @param string ǥ쥯ȥ̾Хѥ
     * @param int ⡼
     */
    function createDirectory($dir, $mode=0777)
    {
        $dirnames = array();
        while (!is_dir($dir)) {
            if (preg_match('/^[^\\\\\/]*[\\\\\/]$/', $dir)) {
                return false;
            }
            $dirnames[] = basename($dir);
            $dir = dirname($dir);
        }

        foreach (array_reverse($dirnames) as $dirname) {
            $dir .= "/{$dirname}";
            mkdir($dir);
            chmod($dir, $mode);

        }
    }

    /**
     * ǥ쥯ȥե
     *
     * @static
     * @access public
     * @param string ǥ쥯ȥ
     * @param bool true: ǥ쥯ȥfalse: ǥ쥯ȥʤ
     * @param bool true: եfalse: եʤ
     * @param int Ԥ糬
     * @return array ǥ쥯ȥե
     */
    function getFiles($file, $is_get_dir=true, $is_get_file=true, $limit_depth=1)
    {
        $files = array();
        if (is_dir($file)) {
            if ($dh = opendir($file)) {
                while (($name = readdir($dh)) !== false) {
                    if (($name != '.') && ($name != '..')) {
                        switch ($file) {
                        case '/':
                        case '\\':
                            $name = "/{$name}";
                            break;
                        default:
                            $name = "{$file}/{$name}";
                        }
                        $element =& SyL_Filesystem::factory($name);
                        if ($element->isDir()) {
                            if ($limit_depth === null) {
                                $files = array_merge($files, SyL_FilesystemDirectory::getFiles($element->getName(), $is_get_dir, $is_get_file, null));
                            } else if ($limit_depth > 1) {
                                $files = array_merge($files, SyL_FilesystemDirectory::getFiles($element->getName(), $is_get_dir, $is_get_file, $limit_depth - 1));
                            }
                            if ($is_get_dir) {
                                $files[] = $element;
                            }
                        } else {
                            if ($is_get_file) {
                                $files[] = $element;
                            }
                        }
                    }
                }
                closedir($dh);
            }
        }
        return $files;
    }

    /**
     * Ǥ򸡺
     *
     * @static
     * @access public
     * @param string ǥ쥯ȥ
     * @param string ե̾
     * @param bool true: ǥ쥯ȥfalse: ǥ쥯ȥʤ
     * @param bool true: եfalse: եʤ
     * @param int Ԥ糬
     * @return array ǥ쥯ȥե
     */
    function searchFiles($file, $word, $is_get_dir=true, $is_get_file=true, $limit_depth=1)
    {
        $files = array();
        foreach (SyL_FilesystemDirectory::getFiles($file, $is_get_dir, $is_get_file, $limit_depth) as $file) {
            if (strpos($file->getName(true), $word) !== false) {
                $files[] = $file;
            }
        }
        return $files;
    }

    /**
     * ʥǥ쥯ȥե륵ˤ
     *
     * @static
     * @access public
     * @param string ǥ쥯ȥ
     * @param bool true: ǥ쥯ȥΥޤࡢfase: ǥ쥯ȥΥޤޤʤ
     * @return int 
     */
    function getTotalSize($file, $is_dir_size=false)
    {
        $size = 0;
        foreach (SyL_FilesystemDirectory::getFiles($file, $is_dir_size, true, null) as $file) {
            $size += $file->getSize();
        }
        return $size;
    }
}

?>
