<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilEnv.php,v 1.2 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ¹ԴĶ饹
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilEnv.php,v 1.2 2008/01/15 09:19:03 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_UtilEnv
{
    /**
     * WindowsưƤ뤫Ƚꤹ
     *
     * @static
     * @access public
     * @return string ΥץȥեΥʡ̾
     */
    function isWindowsOs()
    {
        return (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN');
    }

    /**
     * ΥץȥեΥʡ̾
     *
     * @static
     * @access public
     * @return string ΥץȥեΥʡ̾
     */
    function getScriptOwner()
    {
        return get_current_user();
    }

    /**
     * OSΥ桼̾桼ID
     *
     * @static
     * @access public
     * @param int 桼ID
     * @return string 桼̾
     */
    function getOsUser($user_id)
    {
        $user_name = '';
        if (!call_user_func(array(__CLASS__, 'isWindowsOs')) &&
            function_exists('posix_getpwuid')) {
            $user_info = posix_getpwuid($user_id);
            $user_name = $user_info['name'];
        }
        return $user_name;
    }

    /**
     * ȥץΥ桼̾
     *
     * @static
     * @access public
     * @return string 桼̾
     */
    function getProcessUser()
    {
        $user_name = '';
        if (!call_user_func(array(__CLASS__, 'isWindowsOs')) &&
            function_exists('posix_getuid')) {
            $user_info = posix_getpwuid(posix_getuid());
            $user_name = $user_info['name'];
        }
        return $user_name;
    }
}

?>
