<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceBooksDVDSearchResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹ʳŷ - ŷDVDAPIѡ
 *
 * ܺ٤ϡŷ֥ӥ󥿡
 *   http://webservice.rakuten.co.jp/
 * ŷDVDAPI
 *   http://webservice.rakuten.co.jp/api/dvdsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceBooksDVDSearchResponse.php,v 1.1 2008/03/01 05:01:22 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceBooksDVDSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 
     *
     * @access private
     * @var int
     */
    var $count = 0;
    /**
     * ڡֹ
     *
     * @access private
     * @var int
     */
    var $page = 0;
    /**
     * ڡ⾦ʻ
     *
     * @access private
     * @var int
     */
    var $first = 0;
    /**
     * ڡ⾦ʽ
     *
     * @access private
     * @var int
     */
    var $last = 0;
    /**
     * ҥåȷ
     *
     * @access private
     * @var int
     */
    var $hits = 0;
    /**
     * ꥢ
     *
     * @access private
     * @var int
     */
    var $carrier = 0;
    /**
     * ڡ
     *
     * @access private
     * @var int
     */
    var $page_count = 0;
    /**
     * ʾ
     *
     * @access private
     * @var array
     */
    var $items = array();
    /**
     * 
     *
     * @access private
     * @var array
     */
    var $current_genre = array();
    /**
     * ҥ
     *
     * @access private
     * @var array
     */
    var $child_genres = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;
        static $j = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        // 
        case '/Response/Body/dvdSearch:DVDSearch/count': $this->count = $text; break;
        // ڡֹ
        case '/Response/Body/dvdSearch:DVDSearch/page': $this->page = $text; break;
        // ڡ⾦ʻ
        case '/Response/Body/dvdSearch:DVDSearch/first': $this->first = $text; break;
        // ڡ⾦ʽ
        case '/Response/Body/dvdSearch:DVDSearch/last': $this->last = $text; break;
        // ҥåȷ
        case '/Response/Body/dvdSearch:DVDSearch/hits': $this->hits = $text; break;
        // ꥢ
        case '/Response/Body/dvdSearch:DVDSearch/carrier': $this->carrier = $text; break;
        // ڡ
        case '/Response/Body/dvdSearch:DVDSearch/pageCount': $this->page_count = $text; break;

        case '/Response/Body/dvdSearch:DVDSearch/Items/Item': $i++; break;
        // ̾
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/itemName': $this->items[$i]['itemName'] = $text; break;
        // ʥ
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/itemCode': $this->items[$i]['itemCode'] = $text; break;
        // ʲ
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/itemPrice': $this->items[$i]['itemPrice'] = $text; break;
        // ʬ
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/itemCaption': $this->items[$i]['itemCaption'] = $text; break;
        // URL
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/itemUrl': $this->items[$i]['itemUrl'] = $text; break;
        // եꥨURL
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/affiliateUrl': $this->items[$i]['affiliateUrl'] = $text; break;
        // ʲ̵ͭե饰
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/imageFlag': $this->items[$i]['imageFlag'] = $text; break;
        // ʲ64x64URL
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/smallImageUrl': $this->items[$i]['smallImageUrl'] = $text; break;
        // ʲ128x128URL
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/mediumImageUrl': $this->items[$i]['mediumImageUrl'] = $text; break;
        // ǽե饰
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/availability': $this->items[$i]['availability'] = $text; break;
        // ǥե饰
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/taxFlag': $this->items[$i]['taxFlag'] = $text; break;
        // ե饰
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/postageFlag': $this->items[$i]['postageFlag'] = $text; break;
        // 쥸åȥѲǽե饰
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/creditCardFlag': $this->items[$i]['creditCardFlag'] = $text; break;
        // åץ֥䡼ե饰
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/shopOfTheYearFlag': $this->items[$i]['shopOfTheYearFlag'] = $text; break;
        // եꥨΨ
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/affiliateRate': $this->items[$i]['affiliateRate'] = $text; break;
        // 䳫ϻ
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/startTime': $this->items[$i]['startTime'] = $text; break;
        // 佪λ
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/endTime': $this->items[$i]['endTime'] = $text; break;
        // ӥ塼
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/reviewCount': $this->items[$i]['reviewCount'] = $text; break;
        // ӥ塼ʿ
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/reviewAverage': $this->items[$i]['reviewAverage'] = $text; break;
        // Ź̾
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/shopName': $this->items[$i]['shopName'] = $text; break;
        // Źޥ
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/shopCode': $this->items[$i]['shopCode'] = $text; break;
        // ŹURL
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/shopUrl': $this->items[$i]['shopUrl'] = $text; break;
        // ID
        case '/Response/Body/dvdSearch:DVDSearch/Items/Item/genreId': $this->items[$i]['genreId'] = $text; break;

        // ID
        case '/Response/Body/dvdSearch:DVDSearch/GenreInformation/current/genreId': $this->current_genre['genreId'] = $text; break;
        // ̾
        case '/Response/Body/dvdSearch:DVDSearch/GenreInformation/current/genreName': $this->current_genre['genreName'] = $text; break;
        // ɳŤʿ
        case '/Response/Body/dvdSearch:DVDSearch/GenreInformation/current/itemCount': $this->current_genre['itemCount'] = $text; break;
        // 볬
        case '/Response/Body/dvdSearch:DVDSearch/GenreInformation/current/genreLevel': $this->current_genre['genreLevel'] = $text; break;

        case '/Response/Body/dvdSearch:DVDSearch/GenreInformation/child': $j++; break;
        // ID
        case '/Response/Body/dvdSearch:DVDSearch/GenreInformation/child/genreId': $this->child_genres[$j]['genreId'] = $text; break;
        // ̾
        case '/Response/Body/dvdSearch:DVDSearch/GenreInformation/child/genreName': $this->child_genres[$j]['genreName'] = $text; break;
        // ɳŤʿ
        case '/Response/Body/dvdSearch:DVDSearch/GenreInformation/child/itemCount': $this->child_genres[$j]['itemCount'] = $text; break;
        // 볬
        case '/Response/Body/dvdSearch:DVDSearch/GenreInformation/child/genreLevel': $this->child_genres[$j]['genreLevel'] = $text; break;

        // 嵭ʳ
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 
     *
     * @access public
     * @return int 
     */
    function getCount()
    {
        return $this->count;
    }

    /**
     * ڡֹ
     *
     * @access public
     * @return int 
     */
    function getPage()
    {
        return $this->page;
    }

    /**
     * ڡ⾦ʻ֤
     *
     * @access public
     * @return int 
     */
    function getFirst()
    {
        return $this->first;
    }

    /**
     * ڡ⾦ʽ֤
     *
     * @access public
     * @return int 
     */
    function getLast()
    {
        return $this->last;
    }

    /**
     * ꥢ
     *
     * @access public
     * @return int 
     */
    function getCarrier()
    {
        return $this->carrier;
    }

    /**
     * ڡ
     *
     * @access public
     * @return int 
     */
    function getPageCount()
    {
        return $this->page_count;
    }

    /**
     * ʾ
     *
     * @access public
     * @return array ʾ
     */
    function getItems()
    {
        return $this->items;
    }

    /**
     * 
     *
     * @access public
     * @param string ̾
     * @return mixed 
     */
    function getCurrentGenre($name=null)
    {
        if ($name !== null) {
            return isset($this->current_genre[$name]) ? $this->current_genre[$name] : null;
        } else {
            return $this->current_genre;
        }
    }

    /**
     * ҥ
     *
     * @access public
     * @return array ҥ
     */
    function getChildGenres()
    {
        return $this->child_genres;
    }
}

?>
