<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpMAServiceResponse.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ܸǲWebӥ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ܸǲWebӥ
 *   http://developer.yahoo.co.jp/jlp/MAService/V1/parse.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpMAServiceResponse.php,v 1.1 2008/09/11 13:06:59 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceJlpMAServiceResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * Ǥ
     *
     * @access private
     * @var int
     */
     var $ma_total_count = 0;
    /**
     * ե륿˥ޥåǿ
     *
     * @access private
     * @var int
     */
     var $ma_filtered_count = 0;
    /**
     * ǤΥꥹ
     *
     * @access private
     * @var string
     */
     var $ma_word_list = array();
    /**
     * ǤƱǡ
     *
     * @access private
     * @var int
     */
     var $uniq_total_count = 0;
    /**
     * ե륿˥ޥåǿƱǡ
     *
     * @access private
     * @var int
     */
     var $uniq_filtered_count = 0;
    /**
     * ǤΥꥹȡƱǡ
     *
     * @access private
     * @var string
     */
     var $uniq_word_list = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $ma_i   = -1;
        static $uniq_i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        // Ǥ
        case '/ResultSet/ma_result/total_count': $this->ma_total_count = $text; break;
        // ե륿˥ޥåǿ
        case '/ResultSet/ma_result/filtered_count': $this->ma_filtered_count = $text; break;
        // 
        case '/ResultSet/ma_result/word_list/word': $ma_i++; break;
        // Ǥɽ
        case '/ResultSet/ma_result/word_list/word/surface': $this->ma_word_list[$ma_i]['surface'] = $text; break;
        // Ǥɤߤ
        case '/ResultSet/ma_result/word_list/word/reading': $this->ma_word_list[$ma_i]['reading'] = $text; break;
        // Ǥʻ
        case '/ResultSet/ma_result/word_list/word/pos': $this->ma_word_list[$ma_i]['pos'] = $text; break;
        // Ǥδܷɽ
        case '/ResultSet/ma_result/word_list/word/baseform': $this->ma_word_list[$ma_i]['baseform'] = $text; break;

        // ǤƱǡ
        case '/ResultSet/uniq_result/total_count': $this->uniq_total_count = $text; break;
        // ե륿˥ޥåǿƱǡ
        case '/ResultSet/uniq_result/filtered_count': $this->uniq_filtered_count = $text; break;
        // ǡƱǡ
        case '/ResultSet/uniq_result/word_list/word': $uniq_i++; break;
        // ǤɽƱǡ
        case '/ResultSet/uniq_result/word_list/word/surface': $this->uniq_word_list[$uniq_i]['surface'] = $text; break;
        // ǤɤߤʡƱǡ
        case '/ResultSet/uniq_result/word_list/word/reading': $this->uniq_word_list[$uniq_i]['reading'] = $text; break;
        // ǤʻƱǡ
        case '/ResultSet/uniq_result/word_list/word/pos': $this->uniq_word_list[$uniq_i]['pos'] = $text; break;
        // ǤδܷɽƱǡ
        case '/ResultSet/uniq_result/word_list/word/baseform': $this->uniq_word_list[$uniq_i]['baseform'] = $text; break;
        // uniq_result  word ˸롢Ǥνи
        case '/ResultSet/uniq_result/word_list/word/count': $this->uniq_word_list[$uniq_i]['count'] = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * Ǥ
     *
     * @access public
     * @return int Ǥ
     */
    function getMaTotalCount()
    {
        return $this->ma_total_count;
    }

    /**
     * ե륿˥ޥåǿ
     *
     * @access public
     * @return int ե륿˥ޥåǿ
     */
    function getMaFilteredCount()
    {
        return $this->ma_filtered_count;
    }

    /**
     * ǤΥꥹȤ
     *
     * @access public
     * @return array ǤΥꥹ
     */
    function getMaWordList()
    {
        return $this->ma_word_list;
    }

    /**
     * ǤƱǡ
     *
     * @access public
     * @return int Ǥ
     */
    function getUniqTotalCount()
    {
        return $this->uniq_total_count;
    }

    /**
     * ե륿˥ޥåǿƱǡ
     *
     * @access public
     * @return int ե륿˥ޥåǿ
     */
    function getUniqFilteredCount()
    {
        return $this->uniq_filtered_count;
    }

    /**
     * ǤΥꥹȤƱǡ
     *
     * @access public
     * @return array ǤΥꥹ
     */
    function getUniqWordList()
    {
        return $this->uniq_word_list;
    }
}

?>
