<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingCategoryrankingResponse.php,v 1.1 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ƥ󥭥ѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ƥ󥭥
 *   http://developer.yahoo.co.jp/shopping/categoryranking/V1/categoryRanking.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingCategoryrankingResponse.php,v 1.1 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceShoppingCategoryrankingResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ǡΥޥå꡼
     *
     * @access private
     * @var int 
     */
     var $total_results_available = 0;
    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access private
     * @var int 
     */
    var $total_results_returned = 0;
    /**
     * ̤κǽΥݥ
     *
     * @access private
     * @var int 
     */
    var $first_result_position = 0;
    /**
     * 󥭥󥰾
     *
     * @access private
     * @var array
     */
    var $ranking_info = array();
    /**
     * 󥭥󥰥ǡ
     *
     * @access private
     * @var array
     */
    var $ranking_datas = array();
    /**
     * ƥǡ
     *
     * @access private
     * @var array
     */
    var $categories = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;
        static $j = -1;
        static $k = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsAvailable'])) {
                $this->total_results_available = $attribute['totalResultsAvailable'];
            }
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            if (isset($attribute['firstResultPosition'])) {
                $this->first_result_position = $attribute['firstResultPosition'];
            }
            break;

        // 󥭥󥰾
        case '/ResultSet/Result/RankingInfo/LastModified': $this->ranking_info['LastModified'] = $text; break;
        case '/ResultSet/Result/RankingInfo/StertDate':    $this->ranking_info['StertDate']    = $text; break;
        case '/ResultSet/Result/RankingInfo/EndDate':      $this->ranking_info['EndDate']      = $text; break;
        case '/ResultSet/Result/RankingInfo/CategoryId':   $this->ranking_info['CategoryId']   = $text; break;
        case '/ResultSet/Result/RankingInfo/Gender':       $this->ranking_info['Gender']       = $text; break;
        case '/ResultSet/Result/RankingInfo/Generation':   $this->ranking_info['Generation']   = $text; break;
        case '/ResultSet/Result/RankingInfo/Period':       $this->ranking_info['Period']       = $text; break;

        // 󥭥󥰥ǡ
        case '/ResultSet/Result/RankingData':
            $i++;
            if (isset($attribute['rank'])) {
                $this->ranking_datas[$i]['_attributes']['rank'] = $attribute['rank'];
            }
            if (isset($attribute['vector'])) {
                $this->ranking_datas[$i]['_attributes']['vector'] = $attribute['vector'];
            }
            if (isset($attribute['type'])) {
                $this->ranking_datas[$i]['_attributes']['type'] = $attribute['type'];
            }
            break;

        case '/ResultSet/Result/RankingData/Name': $this->ranking_datas[$i]['Name'] = $text; break;
        case '/ResultSet/Result/RankingData/Code': $this->ranking_datas[$i]['Code'] = $text; break;
        case '/ResultSet/Result/RankingData/Url':  $this->ranking_datas[$i]['Url']  = $text; break;

        case '/ResultSet/Result/RankingData/Image/Id':     $this->ranking_datas[$i]['Image']['Id']     = $text; break;
        case '/ResultSet/Result/RankingData/Image/Small':  $this->ranking_datas[$i]['Image']['Small']  = $text; break;
        case '/ResultSet/Result/RankingData/Image/Medium': $this->ranking_datas[$i]['Image']['Medium'] = $text; break;

        case '/ResultSet/Result/RankingData/Store/Id':   $this->ranking_datas[$i]['Image']['Id']   = $text; break;
        case '/ResultSet/Result/RankingData/Store/Name': $this->ranking_datas[$i]['Image']['Name'] = $text; break;
        case '/ResultSet/Result/RankingData/Store/Url':  $this->ranking_datas[$i]['Image']['Url']  = $text; break;

        // ƥǡ
        case '/ResultSet/Result/Categories/Current/Id':       $this->categories['Current']['Id']       = $text; break;
        case '/ResultSet/Result/Categories/Current/ParentId': $this->categories['Current']['ParentId'] = $text; break;
        case '/ResultSet/Result/Categories/Current/Url':      $this->categories['Current']['Url']      = $text; break;

        case '/ResultSet/Result/Categories/Current/Title/Short':  $this->categories['Current']['Title']['Short']  = $text; break;
        case '/ResultSet/Result/Categories/Current/Title/Medium': $this->categories['Current']['Title']['Medium'] = $text; break;
        case '/ResultSet/Result/Categories/Current/Title/Long':   $this->categories['Current']['Title']['Long']   = $text; break;

        case '/ResultSet/Result/Categories/Current/Path/Category':
            $j++;
            if (isset($attribute['depth'])) {
                $this->categories['Current']['Path']['Category'][$j]['_attributes']['depth'] = $attribute['depth'];
            }
            break;

        case '/ResultSet/Result/Categories/Current/Path/Category/Id':         $this->categories['Current']['Path']['Category'][$j]['Id'] = $text; break;
        case '/ResultSet/Result/Categories/Current/Path/Category/ParentId':   $this->categories['Current']['Path']['Category'][$j]['ParentId'] = $text; break;
        case '/ResultSet/Result/Categories/Current/Path/Category/Title/Name': $this->categories['Current']['Path']['Category'][$j]['Title']['Name'] = $text; break;

        case '/ResultSet/Result/Categories/Children/Child':
            $k++;
            if (isset($attribute['sortOrder'])) {
                $this->categories['Children']['Child'][$k]['_attributes']['sortOrder'] = $attribute['sortOrder'];
            }
            break;

        case '/ResultSet/Result/Categories/Children/Child/Id':  $this->categories['Children']['Child'][$k]['Id']  = $text; break;
        case '/ResultSet/Result/Categories/Children/Child/Url': $this->categories['Children']['Child'][$k]['Url'] = $text; break;

        case '/ResultSet/Result/Categories/Children/Child/Title/Short':  $this->categories['Children']['Child'][$k]['Title']['Short']  = $text; break;
        case '/ResultSet/Result/Categories/Children/Child/Title/Medium': $this->categories['Children']['Child'][$k]['Title']['Medium'] = $text; break;
        case '/ResultSet/Result/Categories/Children/Child/Title/Long':   $this->categories['Children']['Child'][$k]['Title']['Long']   = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ǡΥޥå꡼
     *
     * @access public
     * @return int ǡΥޥå꡼
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getFirstResultPosition()
    {
        return $this->first_result_position;
    }

    /**
     * 󥭥󥰾
     *
     * @access public
     * @param string 
     * @return mixed 󥭥󥰾
     */
    function getRankingInfo($name=null)
    {
        if ($name !== null) {
            return isset($this->ranking_info[$name]) ? $this->ranking_info[$name] : null;
        } else {
            return $this->ranking_info;
        }
    }

    /**
     * 󥭥󥰥ǡ
     *
     * @access public
     * @return array 󥭥󥰥ǡ
     */
    function getRankingDatas()
    {
        return $this->ranking_datas;
    }

    /**
     * ƥǡ
     *
     * @access public
     * @return array ƥǡ
     */
    function getCategories()
    {
        return $this->categories;
    }
}

?>
