<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingCategorysearchRequest.php,v 1.1 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ƥIDѡ
 */
require_once 'SyL_WebServiceShoppingCategorysearchResponse.php';

/**
 * WEBӥꥯȥ饹Yahoo! Japan - ƥIDѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ƥID
 *   http://developer.yahoo.co.jp/shopping/categorysearch/V1/categorySearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingCategorysearchRequest.php,v 1.1 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceShoppingCategorysearchRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBӥСΥۥ̾
     *
     * @access protected
     * @var string
     */
    var $host = 'shopping.yahooapis.jp';
    /**
     * ¹URLѥ
     *
     * @access protected
     * @var string
     */
    var $path = '/ShoppingWebService/V1/categorySearch';
    /**
     * 쥹ݥ󥹥饹̾
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceShoppingCategorysearchResponse';

    /**
     * Yahoo! JAPANեꥨ(yid)ȥХ塼ޡեꥨ(vc)򥻥åȤ
     *
     * @access public
     * @param string Yahoo! JAPANեꥨ(yid)ޤϥХ塼ޡեꥨ(vc)
     */
    function setAffiliateType($affiliate_type)
    {
        switch ($type) {
        case 'yid':
        case 'vc':
            parent::set('affiliate_type', $affiliate_type);
            break;
        default:
            trigger_error("[SyL error] Invalid `affiliate_type' property ({$affiliate_type}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Yahoo! JAPANեꥨID⤷ϡХ塼ޡեꥨID򥻥åȤ
     *
     * @access public
     * @param string Yahoo! JAPANեꥨID⤷ϡХ塼ޡեꥨID
     */
    function setAffiliateId($affiliate_id)
    {
        parent::set('affiliate_id', $affiliate_id);
    }

    /**
     * JSONPȤƽϤݤΥХåؿ̾򥻥åȤ
     *
     * @access public
     * @param string JSONPȤƽϤݤΥХåؿ̾
     */
    function setCallback($callback)
    {
        parent::set('callback', $callback);
    }

    /**
     * ƥID򥻥åȤ
     *
     * @access public
     * @param int ƥID
     */
    function setCategoryId($category_id)
    {
        if (preg_match('/^\d+$/', $category_id)) {
            parent::set('category_id', $category_id);
        } else {
            trigger_error("[SyL error] Invalid `category_id' property ({$category_id}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}

?>
