<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingItemsearchResponse.php,v 1.1 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBӥ쥹ݥ󥹥饹Yahoo! Japan - ʸѡ
 *
 * ܺ٤ϡYahoo!ǥ٥åѡͥåȥ
 *   http://developer.yahoo.co.jp/
 * ʸ
 *   http://developer.yahoo.co.jp/shopping/itemsearch/V1/itemSearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingItemsearchResponse.php,v 1.1 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_WebServiceShoppingItemsearchResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * ǡΥޥå꡼
     *
     * @access private
     * @var int 
     */
     var $total_results_available = 0;
    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access private
     * @var int 
     */
    var $total_results_returned = 0;
    /**
     * ̤κǽΥݥ
     *
     * @access private
     * @var int 
     */
    var $first_result_position = 0;
    /**
     * ꥯȾ
     *
     * @access private
     * @var array
     */
    var $request = array();
    /**
     * ⥸塼
     *
     * @access private
     * @var array
     */
    var $modules = array();
    /**
     * ̥ǡ
     *
     * @access private
     * @var array
     */
    var $hits = array();

    /**
     * XMLǡƼϥɥ᥽å
     *
     * @access protected
     * @param string XMLΥѥ
     * @param string XMLΥ°
     * @param string XMLΥ
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsAvailable'])) {
                $this->total_results_available = $attribute['totalResultsAvailable'];
            }
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            if (isset($attribute['firstResultPosition'])) {
                $this->first_result_position = $attribute['firstResultPosition'];
            }
            break;

        // ꥯȾ
        case '/ResultSet/Result/Request/Query': $this->request['Query'] = $text; break;

        // ⥸塼
        case '/ResultSet/Result/Modules/PriceRanges': $this->modules['PriceRanges'] = array(); break;
        case '/ResultSet/Result/Modules/PriceRanges/Range': $this->modules['PriceRanges']['Range'] = array(); break;
        case '/ResultSet/Result/Modules/PriceRanges/Range/Low':  $this->modules['PriceRanges']['Range']['Low']  = $text; break;
        case '/ResultSet/Result/Modules/PriceRanges/Range/High': $this->modules['PriceRanges']['Range']['High'] = $text; break;
        case '/ResultSet/Result/Modules/PriceRanges/Range/Hits': $this->modules['PriceRanges']['Range']['Hits'] = $text; break;

        case '/ResultSet/Result/Modules/Subcategories': $this->modules['Subcategories'] = array(); break;
        case '/ResultSet/Result/Modules/Path': $this->modules['Subcategories']['Path'] = array(); break;
        case '/ResultSet/Result/Modules/Path/Category': $this->modules['Subcategories']['Path']['Category'] = array(); break;
        case '/ResultSet/Result/Modules/Path/Category/Id':   $this->modules['Subcategories']['Path']['Category']['Id']   = $text; break;
        case '/ResultSet/Result/Modules/Path/Category/Name': $this->modules['Subcategories']['Path']['Category']['Name'] = $text; break;

        case '/ResultSet/Result/Modules/Children': $this->modules['Subcategories']['Children'] = array(); break;
        case '/ResultSet/Result/Modules/Children/Child': $this->modules['Subcategories']['Children']['Child'] = array(); break;
        case '/ResultSet/Result/Modules/Children/Child/Id': $this->modules['Subcategories']['Children']['Child']['Id'] = $text; break;
        case '/ResultSet/Result/Modules/Children/Child/Name': $this->modules['Subcategories']['Children']['Child']['Name'] = $text; break;
        case '/ResultSet/Result/Modules/Children/Child/Hits': $this->modules['Subcategories']['Children']['Child']['Hits'] = $text; break;

        // 
        case '/ResultSet/Result/Hit': $i++; break;
        // ̾
        case '/ResultSet/Result/Hit/Name': $this->hits[$i]['Name'] = $text; break;
        // URL
        case '/ResultSet/Result/Hit/Url': $this->hits[$i]['Url'] = $text; break;
        // 
        case '/ResultSet/Result/Hit/Description': $this->hits[$i]['Description'] = $text; break;
        // åԡ
        case '/ResultSet/Result/Hit/Headline': $this->hits[$i]['Headline'] = $text; break;
        // Ǥ뤫
        case '/ResultSet/Result/Hit/Availability': $this->hits[$i]['Availability'] = $text; break;
        // ʥ
        case '/ResultSet/Result/Hit/Code': $this->hits[$i]['Code'] = $text; break;
        // ʪID
        case '/ResultSet/Result/Hit/PersonId': $this->hits[$i]['PersonId'] = $text; break;
        // JAN
        case '/ResultSet/Result/Hit/JanCode': $this->hits[$i]['JanCode'] = $text; break;
        // ISBN(ҥ)
        case '/ResultSet/Result/Hit/IsbnCode': $this->hits[$i]['IsbnCode'] = $text; break;
        // 
        case '/ResultSet/Result/Hit/Model': $this->hits[$i]['Model'] = $text; break;

        // 
        case '/ResultSet/Result/Hit/Image': $this->hits[$i]['Image'] = array(); break;
        // ID
        case '/ResultSet/Result/Hit/Image/Id': $this->hits[$i]['Image']['Id'] = $text; break;
        // 7676βURL
        case '/ResultSet/Result/Hit/Image/Small': $this->hits[$i]['Image']['Small'] = $text; break;
        // 146146βURL
        case '/ResultSet/Result/Hit/Image/Medium': $this->hits[$i]['Image']['Medium'] = $text; break;

        // 
        case '/ResultSet/Result/Hit/Price': $this->hits[$i]['Price'] = $text; break;

        // ɽ
        case '/ResultSet/Result/Hit/PriceLabel': $this->hits[$i]['PriceLabel'] = array(); break;
        // 
        case '/ResultSet/Result/Hit/PriceLabel/FixedPrice': $this->hits[$i]['PriceLabel']['FixedPrice'] = $text; break;
        // 
        case '/ResultSet/Result/Hit/PriceLabel/SalePrice': $this->hits[$i]['PriceLabel']['SalePrice'] = $text; break;

        // ݥ
        case '/ResultSet/Result/Hit/Point': $this->hits[$i]['Point'] = array(); break;
        // ݥȿ
        case '/ResultSet/Result/Hit/Point/Amount': $this->hits[$i]['Point']['Amount'] = $text; break;
        // ݥΨ
        case '/ResultSet/Result/Hit/Point/Times': $this->hits[$i]['Point']['Times'] = $text; break;

        // 
        case '/ResultSet/Result/Hit/Shipping': $this->hits[$i]['Shipping'] = array(); break;
        // 拾
        case '/ResultSet/Result/Hit/Shipping/Code': $this->hits[$i]['Shipping']['Code'] = $text; break;
        // ʤ/̵/̵
        case '/ResultSet/Result/Hit/Shipping/Name': $this->hits[$i]['Shipping']['Name'] = $text; break;

        // 
        case '/ResultSet/Result/Hit/CategoryIdPath': $this->hits[$i]['CategoryIdPath'] = array(); break;
        // ߥƥIDޤǤΥ롼ȤΥѥ¤
        case '/ResultSet/Result/Hit/CategoryIdPath/Category/Id': $this->hits[$i]['CategoryIdPath']['Category']['Id'][] = $text; break;

        // 
        case '/ResultSet/Result/Hit/Brands': $this->hits[$i]['Brands'] = array(); break;
        // ֥̾
        case '/ResultSet/Result/Hit/Brands/Name': $this->hits[$i]['Brands']['Name'] = $text; break;
        // ֥̾
        case '/ResultSet/Result/Hit/Brands/Path/Brand/Id': $this->hits[$i]['Brands']['Path']['Brand']['Id'][] = $text; break;

        // ȥ
        case '/ResultSet/Result/Hit/Store': $this->hits[$i]['Store'] = array(); break;
        // ȥID
        case '/ResultSet/Result/Hit/Store/Id': $this->hits[$i]['Store']['Id'] = $text; break;
        // ȥURL
        case '/ResultSet/Result/Hit/Store/Url': $this->hits[$i]['Store']['Url'] = $text; break;
        // ȥ̾
        case '/ResultSet/Result/Hit/Store/Name': $this->hits[$i]['Store']['Name'] = $text; break;
        // ٥ȥȥɤ
        case '/ResultSet/Result/Hit/Store/IsBestStore': $this->hits[$i]['Store']['IsBestStore'] = $text; break;

        // ɾ
        case '/ResultSet/Result/Hit/Store/Ratings': $this->hits[$i]['Store']['Ratings'] = array(); break;
        // ȥɾ
        case '/ResultSet/Result/Hit/Store/Ratings/Rate': $this->hits[$i]['Store']['Ratings']['Rate'] = $text; break;
        // ɾͿ
        case '/ResultSet/Result/Hit/Store/Ratings/Count': $this->hits[$i]['Store']['Ratings']['Count'] = $text; break;

        // ʧ
        case '/ResultSet/Result/Hit/Store/Payment': $this->hits[$i]['Store']['Payment'] = array(); break;
        // ʧ
        case '/ResultSet/Result/Hit/Store/Payment/Method': $this->hits[$i]['Store']['Payment']['Method'] = array(); break;
        // ʧ
        case '/ResultSet/Result/Hit/Store/Payment/Method/Code': $this->hits[$i]['Store']['Payment']['Method']['Code'] = $text; break;
        // ʧ̾
        case '/ResultSet/Result/Hit/Store/Payment/Method/Name': $this->hits[$i]['Store']['Payment']['Method']['Name'] = $text; break;

        // ȥ
        case '/ResultSet/Result/Hit/Store/Image': $this->hits[$i]['Store']['Image'] = array(); break;
        // ID
        case '/ResultSet/Result/Hit/Store/Image/Id': $this->hits[$i]['Store']['Image']['Id'] = $text; break;
        // 12030βURL
        case '/ResultSet/Result/Hit/Store/Image/Medium': $this->hits[$i]['Store']['Image']['Medium'] = $text; break;

        // ¾
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * ǡΥޥå꡼
     *
     * @access public
     * @return int ǡΥޥå꡼
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * ֵѤ졢ĥޥå꡼ο
     *
     * @access public
     * @return int ֵѤ졢ĥޥå꡼ο
     */
    function getFirstResultPosition()
    {
        return $this->first_result_position;
    }

    /**
     * ̥ǡ
     *
     * @access public
     * @return array ̥ǡ
     */
    function getHits()
    {
        return $this->hits;
    }
}

?>
