<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2008 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Application.php,v 1.4 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ץꥱ饹
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2008 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Application.php,v 1.4 2008/09/29 14:41:37 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class Application extends AppAction
{
    var $c_action; // 󥸥
    var $c_application; // 󥸥
    var $c_controller; // 󥸥
    var $c_template; // 󥸥

    /**
     * ץꥱ
     *
     * @access public
     * @param object ǡ֥
     * @param object ƥȥ֥
     */
    function execute(&$data, &$context)
    {
        $project_dir     = $data->geta('d', 0);
        $app_name        = $data->geta('w', 0);
        $is_controller   = $data->is('c');
        $controller_file = $data->geta('c', 0);

        $cmd =& $context->getConsole();

        // -------------------------------------------------
        // ץȥǥ쥯ȥå
        // -------------------------------------------------
        if (!$project_dir) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        }
        if (!preg_match('/(\\\\|\/)$/', $project_dir)) {
            $project_dir .= '/';
        }
        if (!file_exists($project_dir)) {
            trigger_error("[SyL error] Project directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // ץꥱ̾å
        // -------------------------------------------------
        if (!$app_name) {
            trigger_error("[SyL error] Application name (-w) not found", E_USER_ERROR);
            exit;
        } else if (!preg_match('/^[\w\-]+$/', $app_name)) {
            trigger_error("[SyL error] Application name format invalid. ([a-z][A-Z][0-9]-_ only)", E_USER_ERROR);
            exit;
        }

        $app_dir = "{$project_dir}apps/{$app_name}/";

        if (file_exists($app_dir)) {
            if ($cmd->getInput('Already application directory exists', "overwrite application ({$app_dir}) [Y/n]:") != 'Y') {
                $cmd->stdout('*** ' . $data->get(0) . ' stopped');
                exit;
            }
            if (!is_writable($app_dir)) {
                trigger_error("[SyL error] Application directory permission denied ({$app_dir})", E_USER_ERROR);
                exit;
            }
        } else {
            if ($cmd->getInput('', "create application ({$app_dir}) [Y/n]:") != 'Y') {
                $cmd->stdout('*** ' . $data->get(0) . ' stopped');
                exit;
            }
        }

        // -------------------------------------------------
        // ȥեå
        // -------------------------------------------------
        if ($is_controller) {
            if (!$controller_file) {
                // ǥեȤΥȥե
                $controller_file = "{$project_dir}public/{$app_name}.php";
            }
            if (file_exists($controller_file)) {
                if ($cmd->getInput('Already controller file exists', "overwrite controller file ({$controller_file}) [Y/n]:") != 'Y') {
                    $cmd->stdout('*** ' . $data->get(0) . ' stopped');
                    exit;
                }
                if (!is_writable($controller_file)) {
                    trigger_error("[SyL error] Controller file permission denied ({$controller_file})", E_USER_ERROR);
                    exit;
                }
            } else {
                if (!is_writable(dirname($controller_file))) {
                    trigger_error("[SyL error] Controller file permission denied ({$controller_file})", E_USER_ERROR);
                    exit;
                }
            }
        }

        // -------------------------------------------------
        // եå
        // -------------------------------------------------
        $action_files = array('index');

        // -------------------------------------------------
        // ƥץ졼ȥեå
        // -------------------------------------------------
        $template_files = array('index');

        // -------------------------------------------------
        // ץꥱ
        // -------------------------------------------------
        $this->c_application->trigger($cmd, $project_dir, $app_name);

        // -------------------------------------------------
        // ȥե
        // -------------------------------------------------
        if ($controller_file) {
            $this->c_controller->trigger($cmd, $project_dir, $app_name, $controller_file);
        }

        // -------------------------------------------------
        // ե
        // -------------------------------------------------
        $this->c_action->trigger($cmd, $project_dir, $app_name, $action_files);

        // -------------------------------------------------
        // ƥץ졼ȥե
        // -------------------------------------------------
        $this->c_template->trigger($cmd, $project_dir, $app_name, $template_files);
    }

}

?>
