<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowDel.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 管理フローの基底クラス
 */
require_once SYL_FRAMEWORK_DIR . '/core/Adm/SyL_AdmFlow.php';

/**
 * 管理フロー削除クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowDel.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_AdmFlowDel extends SyL_AdmFlow
{
    /**
     * オペレーション名
     *
     * @access protected
     * @var string
     */
    var $opp_name = 'del';

    /**
     * コンストラクタ
     *
     * @access public
     */
    function SyL_AdmFlowDel()
    {
        parent::SyL_AdmFlow();
    }

    /**
     * 削除フロー
     *
     * @access public
     * @param object データ管理オブジェクト
     * @param object コンテキスト管理オブジェクト
     */
    function execute(&$data, &$context)
    {
        if ($context->isPost()) {
            // フォーム取得
            $form =& $this->getForm();
            // 主キーパラメータ名取得
            $key_name = $form->getStructConfig('key_name');
            // パラメータ取得
            $keys = $data->geta($key_name);
            // パラメータチェック
            if (!is_array($keys) || (count($keys) == 0)) {
                SyL_Error::trigger("[Adm error] Key parameter not found");
            }

            // DB接続取得
            $conn =& $context->getDB();
            // ADMオブジェクト作成
            $adm  =& SyL_Adm::factory($form, $conn, $keys);
            // テーブル情報ロード
            $adm->loadConfig();
            // アクセス権チェック
            if (!$adm->isDel()) {
                // アクセス権限なし
                SyL_Error::trigger("[Adm error] Delete Opperation Forbidden");
            }
            // 削除実行
            if (!$this->delete($adm)) {
                $context->closeDB($conn);
                SyL_Error::trigger("[Adm error] Can't Delete Opperation");
            }
            // DB接続終了
            $context->closeDB($conn);

            // 完了画面へリダイレクト
            SyL_Response::redirect($this->getUrl($context, 'fin') . '?adm_action=del');
        } else {
            SyL_Response::redirect($this->getUrl($context, 'lst'));
        }
    }

    /**
     * 削除実行
     *
     * @access public
     * @param object ADMオブジェクト
     */
    function delete(&$adm)
    {
        return $adm->delete();
    }
}
