<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowNew.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 管理フローの基底クラス
 */
require_once SYL_FRAMEWORK_DIR . '/core/Adm/SyL_AdmFlow.php';

/**
 * 管理フロー新規クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmFlowNew.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_AdmFlowNew extends SyL_AdmFlow
{
    /**
     * オペレーション名
     *
     * @access protected
     * @var string
     */
    var $opp_name = 'new';

    /**
     * コンストラクタ
     *
     * @access public
     */
    function SyL_AdmFlowNew()
    {
        parent::SyL_AdmFlow();
    }

    /**
     * 一覧表示処理
     *
     * @access public
     * @param object データ管理オブジェクト
     * @param object コンテキスト管理オブジェクト
     */
    function execute(&$data, &$context)
    {
        // フォーム取得
        $form =& $this->getForm();
        // DB接続取得
        $conn =& $context->getDB();
        // ADMオブジェクト作成
        $adm  =& SyL_Adm::factory($form, $conn);
        // テーブル情報ロード
        $adm->loadConfig();
        // アクセス権チェック
        if (!$adm->isNew()) {
            // アクセス権限なし
            SyL_Error::trigger("[Adm error] New Opperation Forbidden");
        }

        // 表示のみ要素
        $read_only = '';
        if (!$data->get('adm_action_exe')) {
            $read_only = $data->get('adm_read_only');
            if ($read_only) {
                foreach (explode("\t", $read_only) as $column) {
                    $form->setReadOnlyColumn($column);
                }
            }
        }

        // データ取得オブジェクトセット
        $form->registerInput($data);
        // フォーム構築
        $form->build(!$context->isPost());

        // 画面分岐
        if ($context->isPost()) {
            // 次へ進む
            if ($data->get('adm_action_next')) {
                // バリデーション実行
                if ($this->validateAdm($adm)) {
                    // 確認画面へ
                    $form->setReadOnly(true);
                }
            } else if ($data->get('adm_action_exe')) {
                // バリデーション実行
                if ($this->validateAdm($adm)) {
                    // 登録実行
                    $this->insert($adm);
                    // 完了画面へリダイレクト
                    SyL_Response::redirect($this->getUrl($context, 'fin') . '?adm_action=new');
                }
            } else if ($data->get('adm_action_prev')) {
                // 確認画面から戻る
            }
        } else {
            // 初期表示
        }

        // DB接続終了
        $context->closeDB($conn);

        // フォーム要素データ
        $data->set('form',      $form->getResultArray());
        $data->set('read_only', $read_only);
        // 確認表示関連
        $data->set('view_alert',   $form->getStructConfig('view_alert'));
        $data->set('view_confirm', $form->getStructConfig('view_confirm'));

        // 文言関連
        $data->set('title', $form->getStructConfig('title'));

        // リンク先URL
        $data->set('url_lst', $this->getUrl($context, 'lst'));
        $data->set('url_new', $this->getUrl($context, 'new'));
        $data->set('url_dir', dirname($context->getScriptName()));
    }

    /**
     * バリデーション実行
     *
     * @access public
     * @param object ADMオブジェクト
     * @return bool true: バリデーションOK、false: バリデーションエラー
     */
    function validateAdm(&$adm)
    {
        return $adm->validate();
    }

    /**
     * 登録実行
     *
     * @access public
     * @param object ADMオブジェクト
     */
    function insert(&$adm)
    {
        $adm->insert();
    }
}
