<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilterFunction.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * フィルタクラス
 */
require_once SYL_FRAMEWORK_DIR . '/core/SyL_Filter.php';

/**
 * 汎用関数適用フィルタクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FilterFunction.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_FilterFunction extends SyL_Filter
{
    /**
     * リクエストパラメータに特定の関数を適用する
     *
     * @access public
     * @param object リクエストオブジェクト
     * @param string 関数名
     */
    function preAction(&$data, $funcname)
    {
        $data->apply($funcname);
    }

    /**
     * アクションパラメータに特定の関数を適用する
     *
     * @access public
     * @param object データマネージャオブジェクト
     * @param string 関数名
     */
    function postAction(&$data, $funcname)
    {
        $this->preAction($data, $funcname);
    }

    /**
     * 表示ビューに特定の関数を適用する
     *
     * @access public
     * @param object ビューオブジェクト
     * @param string 関数名
     */
    function preRender(&$view, $funcname)
    {
        $render =& $view->getRender();
        $render = $funcname($render);
    }
}
