<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ActionForm.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * フォームクラス
 */
require_once SYL_FRAMEWORK_DIR . '/lib/SyL_Form.php';

/**
 * アクションフォームクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ActionForm.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ActionForm extends SyL_Form
{
    /**
     * フォーム定義要素配列
     * 
     * @access protected
     * @var array
     */
    var $elements_config = array();

    /**
     * コンストラクタ
     *
     * @access public
     * @param string 遷移先URL
     * @param string 機能タイプ
     */
    function SyL_ActionForm($action='')
    {
        parent::SyL_Form($action);
    }

    /**
     * フォーム取得メソッド
     *
     * @static
     * @access public
     * @param string フォームオブジェクト名
     * @param string 遷移先URL
     * @return object フォームオブジェクト
     */
    function &factory($classpath, $action='')
    {
        static $forms = array();
        if (!isset($forms[$classpath])) {
            $classname = class_exists($classpath) ? $classpath : SyL_Loader::convertClass($classpath, true);
            $forms[$classpath] = new $classname($action);
        }
        return $forms[$classpath];
    }

    /**
     * データオブジェクトのコールバックメソッドを登録する
     *
     * @access public
     * @param object データオブジェクト
     */
    function registerInput(&$data)
    {
        // 配列取得許可
        $data->isGetArray(true);
        // パラメータ取得メソッドセット
        $this->registerInputCallback(array(&$data, 'get'));
    }

    /**
     * 要素の属性設定を追加する
     *
     * @access public
     * @param string 要素名
     * @param array 属性配列
     */
    function addConfig($name, $attributes)
    {
        $this->elements_config[$name] = $attributes;
    }

    /**
     * 要素の属性設定を取得する
     *
     * @access public
     * @param string 要素名
     * @return array 属性配列
     */
    function getConfig($name)
    {
        return $this->elements_config[$name];
    }

    /**
     * アクションフォームを構築する
     *
     * @access public
     * @param bool 初期表示フラグ
     */
    function build($init=false)
    {
        // 要素登録ループ
        foreach ($this->elements_config as $name => $values) {
            // 要素作成
            $element =& $this->createElement($name, $values);
            // 初期値判定
            if ($init && isset($values['default'])) {
                $element->setValue($values['default']);
            }
            // バリデーション追加
            if (isset($values['validate']) && (count($values['validate']) > 0)) {
                $this->setElementValidations($element, $values);
            }
            $this->addElement($element);
        }
    }

    /**
     * 要素を作成する
     *
     * @access public
     * @param string 要素名
     * @param array 属性配列
     */
    function &createElement($name, $values)
    {
        $type         = $values['type'];
        $display_name = isset($values['name'])       ? $values['name']       : $name;
        $options      = isset($values['options'])    ? $values['options']    : array();
        $attributes   = isset($values['attributes']) ? $values['attributes'] : array();
        return parent::createElement($type, $name, $display_name, $options, $attributes);
    }

    /**
     * 要素にバリデーションをセットする
     *
     * @access public
     * @param object 要素オブジェクト
     * @param array 属性配列
     */
    function setElementValidations(&$element, $values)
    {
        // バリデーション追加
        $vs =& SyL_Validators::create();
        foreach ($values['validate'] as $v_name => $v_values) {
            $v_parameters = isset($v_values['parameters']) ? $v_values['parameters'] : array();
            $vs->add(SyL_Validator::create($v_name, $v_values['message'], $v_parameters));
        }
        $element->setValidators($vs);
    }

    /**
     * フォーム全要素を配列で取得する
     *
     * @access public
     * @return array フォーム全要素を配列
     */
    function &getResultArray()
    {
        $results =& parent::getResultArray();
        if (!$results['read_only']) {
            foreach (array_keys($results['elements']) as $name) {
                if (isset($this->elements_config[$name])) {
                    if (isset($this->elements_config[$name]['note']) && $this->elements_config[$name]['note']) {
                        $results['elements'][$name]['html'] .= sprintf('<br><span class="note">%s</span>', $this->elements_config[$name]['note']);
                    }
                }
            }
        }
        return $results;
    }
}
