<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Context.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 遷移情報クラス
 */
require_once SYL_FRAMEWORK_DIR . '/core/SyL_Router.php';
/**
 * PHPファイルロードクラス
 */
require_once SYL_FRAMEWORK_DIR . '/core/SyL_Loader.php';

/**
 * フレームワーク情報管理クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Context.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_Context
{
    /**
     * ビュータイプ
     * 
     * @access abstract
     * @var string
     */
    var $view_type = '';
    /**
     * ルータオブジェクト
     * 
     * @access protected
     * @var string
     */
    var $router = null;
    /**
     * パラメータ
     * 
     * @access protected
     * @var string
     */
    var $parameters = array();
    /**
     * executeフェーズ実行フラグ
     * 
     * @access protected
     * @var bool
     */
    var $is_execute = true;
    /**
     * キャッシュタイムアウト[s]
     * 
     * @access private
     * @var int
     */
    var $cache_lifetime = 3600;
    /**
     * キャッシュオブジェクト
     * 
     * @access private
     * @var object
     */
    var $cache = null;

    /**
     * コンストラクタ
     *
     * @access protected
     * @param object データ管理オブジェクト
     */
    function SyL_Context(&$data)
    {
        $this->router =& SyL_Router::factory($data);
        if (!$this->router->getViewType()) {
            $this->router->setViewType($this->view_type);
        }

        if (SYL_CACHE) {
            $this->cache =& SyL_Cache::factory('file');
            $this->cache->setPrefix(SYL_APP_NAME . '.');
            $this->cache->setCacheDir(SYL_APP_CACHE_DIR . '/app/');
        }
    }

    /**
     * コンテキストを取得
     *
     * @access public
     * @param object データ管理オブジェクト
     */
    function &singleton(&$data)
    {
        static $singleton;
        if (!is_object($singleton)) {
            $class_name = 'SyL_Context' . ucfirst(SYL_ENV_TYPE);
            include_once SYL_FRAMEWORK_DIR . "/core/Context/{$class_name}.php";
            // 子クラスのインスタンス生成
            $singleton = new $class_name($data);
        }
        return $singleton;
    }

    /**
     * ルータオブジェクトを取得
     *
     * @access public
     * @return object ルータオブジェクト
     */
    function &getRouter()
    {
        return $this->router;
    }

    /**
     * executeフェーズ実行判定
     *
     * @access public
     * @return bool executeフェーズ実行フラグ
     */
    function isExecute()
    {
        return $this->is_execute;
    }

    /**
     * コンポーネントオブジェクトをセット
     * 
     * @access public
     * @param string コンポーネント名
     * @return object コンポーネント
     */
    function &getComponent($name)
    {
        $container =& SyL_Container::singleton();
        return $container->getComponent($name);
    }

    /**
     * パラメータをセット
     * 
     * @access public
     * @param string パラメータ名
     * @param mixed パラメータ値
     */
    function setParameter($name, $value)
    {
        $this->parameters[$name] = $value;
    }

    /**
     * 全パラメータを取得
     * 
     * @access public
     * @return array 全パラメータ
     */
    function &getParameters()
    {
        return $this->parameters;
    }


    // -----------------------------------------------------
    // DB関連共通メソッド
    // -----------------------------------------------------

    /**
     * DBオブジェクトを取得する
     *
     * @access protected
     * @param string DSN文字列
     * @return object DBオブジェクト
     */
    function &getDB($dsn='')
    {
        static $dsns = array();
        if (!isset($dsns[$dsn])) {
            SyL_Loggers::info("getDB for Action");
            // DBクラスインクルード
            include_once SYL_FRAMEWORK_DIR . '/lib/SyL_DB.php';
            // DBオブジェクト取得
            $dsns[$dsn] =& SyL_DB::getConnection($dsn);
            $dsns[$dsn]->setCallbackSqlLog(array(__CLASS__, 'addLogDBSql'));
            $dsns[$dsn]->setCallbackErrorLog(array(__CLASS__, 'addLogDBError'));
            //register_shutdown_function(array(&$dsns[$dsn], 'closeConnection'));
        }
        return $dsns[$dsn];
    }

    /**
     * DBオブジェクトの接続を開放する
     *
     * @access protected
     * @param object DBオブジェクト
     */
    function closeDB(&$conn)
    {
        if (is_object($conn)) {
            SyL_Loggers::info("DB connection end");
            $conn->closeConnection();
            $conn = null;
        }
    }

    /**
     * SQLをログに記録する
     *
     * @static
     * @access private
     * @param string ログメッセージ
     */
    function addLogDBSql($message)
    {
        SyL_Loggers::debug($message);
    }

    /**
     * DBエラーをログに記録する
     *
     * @static
     * @access private
     * @param string ログメッセージ
     */
    function addLogDBError($message)
    {
        SyL_Loggers::warn($message);
    }


    // -----------------------------------------------------
    // キャッシュ共通メソッド
    // -----------------------------------------------------

    /**
     * キャッシュ有効時間をセットする
     *
     * @access public
     * @param int キャッシュ有効時間
     */
    function setCacheLifetime($lifetime)
    {
        $this->cache_lifetime = $lifetime;
    }

    /**
     * キャッシュを取得する
     *
     * @access public
     * @param string キャッシュのキー
     * @param string キャッシュの接頭辞
     */
    function getCache($key, $prefix='')
    {
        $this->cache->setKey($key);
        $this->cache->setPrefix($prefix);
        $this->cache->setLifeTime($this->cache_lifetime);
        return $this->cache->read();
    }

    /**
     * キャッシュをセットする
     *
     * @access public
     * @param string キャッシュのキー
     * @param mixed キャッシュデータ
     * @param string キャッシュの接頭辞
     */
    function setCache($key, $data, $prefix='')
    {
        $this->cache->setKey($key);
        $this->cache->setPrefix($prefix);
        $this->cache->setLifeTime($this->cache_lifetime);
        $this->cache->write($data);
    }


    // -----------------------------------------------------
    // 認証関連共通メソッド
    // -----------------------------------------------------

    /**
     * ユーザーオブジェクトを取得する
     *
     * @access protected
     * @return object ユーザーオブジェクト
     */
    function &getUser()
    {
        // AUTHクラスインクルード
        include_once SYL_FRAMEWORK_DIR . '/core/SyL_Auth.php';
        $auth =& SyL_Auth::singleton();
        return $auth->getUser();
    }

    /**
     * ユーザーオブジェクトを取得する
     *
     * @access protected
     * @return object ユーザーオブジェクト
     */
    function setUser(&$user)
    {
        // AUTHクラスインクルード
        include_once SYL_FRAMEWORK_DIR . '/core/SyL_Auth.php';
        $auth =& SyL_Auth::singleton();
        $auth->setUser($user);
    }

    /**
     * ログアウトする
     *
     * @access protected
     */
    function doLogout()
    {
        // AUTHクラスインクルード
        include_once SYL_FRAMEWORK_DIR . '/core/SyL_Auth.php';
        $auth =& SyL_Auth::singleton();
        $auth->doLogout();
    }
}
