<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlBuilderTable.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * SQLカラムクラス
 */
require_once 'SyL_DBSqlBuilderColumn.php';

/**
 * SQLテーブルクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_DBSqlBuilderTable.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_DBSqlBuilderTable
{
    /**
     * DBコネクションオブジェクト
     *
     * @access private
     * @var object
     */
    var $conn = null;
    /**
     * テーブル名
     *
     * @access private
     * @var string
     */
    var $name = '';
    /**
     * テーブル別名
     *
     * @access private
     * @var string
     */
    var $alias = '';

    /**
     * コンストラクタ
     *
     * @access public
     * @param object DBオブジェクト
     * @param string テーブル名
     * @param string テーブル別名
     */
    function SyL_DBSqlBuilderTable(&$conn, $name, $alias='')
    {
        $this->conn  =& $conn;
        $this->name  = $name;
        $this->alias = $alias;
    }

    /**
     * テーブル名を取得する
     *
     * @access public
     * @return string テーブル名
     */
    function getName()
    {
        return $this->name;
    }

    /**
     * テーブル別名を取得する
     *
     * @access public
     * @return string テーブル別名
     */
    function getNameAlias()
    {
        return $this->alias;
    }

    /**
     * FROM句用のテーブル名を取得する
     *
     * @access public
     * @return string テーブル別名
     */
    function getNameFrom()
    {
        if ($this->alias) {
            return $this->getName() . ' ' . $this->getNameAlias();
        } else {
            return $this->getName();
        }
    }

    /**
     * カラムオブジェクトを作成する
     *
     * @access public
     * @param string カラム名
     * @param string カラム別名
     * @return object カラムオブジェクト
     */
    function getColumn($name, $alias='')
    {
        return new SyL_DBSqlBuilderColumn($this, $name, $alias);
    }
}
