<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Compress.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ファイル処理クラス
 */
require_once 'SyL_File.php';

/** 
 * 圧縮／解凍クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Compress.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_Compress
{
    /**
     * コンストラクタ
     *
     * @access private
     */
    function SyL_Compress()
    {
    }

    /**
     * データを圧縮する
     *
     * @static
     * @access public
     * @param string 圧縮タイプ
     * @param string 圧縮前データ
     * @param string 保存ファイル
     * @return string 圧縮後データ
     */
    function compress($type, $data, $out_file='')
    {
        $classname = 'SyL_Compress' . ucfirst($type);
        include_once dirname(__FILE__) . "/Compress/{$classname}.php";
        return call_user_func(array($classname, 'compress'), $data, $out_file);
    }

    /**
     * ファイルを圧縮する
     *
     * @static
     * @access public
     * @param string 圧縮タイプ
     * @param string 圧縮対象ファイル
     * @param string 保存ファイル
     * @param bool 圧縮対象ファイル削除フラグ
     * @return string 圧縮後データ
     */
    function compressFromFile($type, $in_file, $out_file='', $in_file_remove=false)
    {
        $classname = 'SyL_Compress' . ucfirst($type);
        include_once dirname(__FILE__) . "/Compress/{$classname}.php";
        return call_user_func(array($classname, 'compressFromFile'), $in_file, $out_file, $in_file_remove);
    }

    /**
     * データを解凍する
     *
     * @static
     * @access public
     * @param string 圧縮タイプ
     * @param string 圧縮データ
     * @param string 保存ファイル
     * @return string 解凍データ
     */
    function extract($type, $data, $out_file='')
    {
        $classname = 'SyL_Compress' . ucfirst($type);
        include_once dirname(__FILE__) . "/Compress/{$classname}.php";
        return call_user_func(array($classname, 'extract'), $data, $out_file);
    }

    /**
     * ファイルを解凍する
     *
     * @static
     * @access public
     * @param string 圧縮タイプ
     * @param string 解凍対象ファイル
     * @param string 保存ファイル
     * @param bool 解凍対象ファイル削除フラグ
     * @return string 解凍データ
     */
    function extractFromFile($type, $in_file, $out_file='', $in_file_remove=false)
    {
        $classname = 'SyL_Compress' . ucfirst($type);
        include_once dirname(__FILE__) . "/Compress/{$classname}.php";
        return call_user_func(array($classname, 'extractFromFile'), $in_file, $out_file, $in_file_remove);
    }

    /**
     * データを圧縮するロジック
     *
     * @access protected
     * @param string 圧縮前データ
     * @return string 圧縮後データ
     */
    function processCompress($data)
    {
    }

    /**
     * データを解凍するロジック
     *
     * @access protected
     * @param string 圧縮データ
     * @return string 解凍データ
     */
    function processExtract($data)
    {
    }

    /**
     * ファイルからデータを取得
     *
     * @access public
     * @param string ファイルパス
     * @return string ファイルの内容
     */
    function readFile($filename, $protocol='')
    {
        if ($protocol) {
            $protocol .= '://';
        }
        return SyL_File::readContents("{$protocol}{$filename}");
    }

    /**
     * ファイルにデータを保存
     *
     * @access public
     * @param string ファイルパス
     * @param string ファイルの内容
     */
    function writeFile($filename, $data)
    {
        SyL_File::writeContents($filename, $data);
    }

}
