<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilCompositeComponent.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * コンポジットパターンに基づく基底クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilCompositeComponent.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_UtilCompositeComponent
{
    /**
     * 名称
     * 
     * @access private
     * @var string
     */
    var $name = '';
    /**
     * 属性
     *
     * @access private
     * @var array
     */
    var $attributes = array();

    /**
     * コンストラクタ
     *
     * @access public
     * @param string 名称
     * @param array 属性配列
     */
    function SyL_UtilCompositeComponent($name=null, $attributes=array())
    {
        if ($name !== null) {
            $this->setName($name);
        }
        $this->attributes += $attributes;
    }

    /**
     * 名称をセット
     *
     * @access protected
     * @param string 名称
     */
    function setName($name)
    {
        $this->name = $name;
    }

    /**
     * 名称を取得
     *
     * @access protected
     * @return string 名称
     */
    function getName()
    {
        return $this->name;
    }

    /**
     * 属性をセット
     *
     * @access protected
     * @param string 属性名
     * @param string 属性値
     */
    function setAttribute($name, $value)
    {
        $this->attributes[$name] = $value;
    }

    /**
     * 属性を取得
     *
     * @access protected
     * @param string 属性名
     * @return string 属性値
     */
    function getAttribute($name)
    {
        return $this->attributes[$name];
    }

    /**
     * 全属性を取得
     *
     * @access protected
     * @return array 属性配列
     */
    function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * 子要素を追加する
     *
     * @access public
     * @param object 子要素
     */
    function add($entry)
    {
    }

    /**
     * ツリー表示する
     *
     * @access public
     * @param int 深さ
     */
    function printTree($depth=0)
    {
        echo str_repeat('    ', $depth);
        echo "{$this->name}\n";
    }

    /**
     * ツリーを取得する
     *
     * @access public
     * @param array ツリーデータ
     */
    function getTree($tree=array())
    {
        $tree['name']       = $this->name;
        $tree['attributes'] = $this->getAttributes();
        $tree['nodes']      = array();
        return $tree;
    }
}
