<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAdDynamicResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天ダイナミックアドAPI用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天ダイナミックアドAPI
 *   http://webservice.rakuten.co.jp/api/dynamicad/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAdDynamicResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceAdDynamicResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 商品情報
     *
     * @access private
     * @var array
     */
    var $ads = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/Response/Body/Ads/Ad': $i++; break;
        // 商品名
        case '/Response/Body/Ads/Ad/ItemName': $this->ads[$i]['ItemName'] = $text; break;
        // 商品コード
        case '/Response/Body/Ads/Ad/ItemCode': $this->ads[$i]['ItemCode'] = $text; break;
        // 商品価格
        case '/Response/Body/Ads/Ad/ItemPrice': $this->ads[$i]['ItemPrice'] = $text; break;
        // アフィリエイトURL
        case '/Response/Body/Ads/Ad/AffiliateItemUrl': $this->ads[$i]['AffiliateItemUrl'] = $text; break;
        // 商品画像64x64URL
        case '/Response/Body/Ads/Ad/SmallImageUrl': $this->ads[$i]['SmallImageUrl'] = $text; break;
        // 商品画像128x128URL
        case '/Response/Body/Ads/Ad/MediumImageUrl': $this->ads[$i]['MediumImageUrl'] = $text; break;
        // 消費税フラグ
        case '/Response/Body/Ads/Ad/TaxFlag': $this->ads[$i]['TaxFlag'] = $text; break;
        // 送料フラグ
        case '/Response/Body/Ads/Ad/PostageFlag': $this->ads[$i]['PostageFlag'] = $text; break;
        // クレジットカード利用可能フラグ
        case '/Response/Body/Ads/Ad/CreditCardFlag': $this->ads[$i]['CreditCardFlag'] = $text; break;
        // レビュー件数
        case '/Response/Body/Ads/Ad/ReviewCount': $this->ads[$i]['ReviewCount'] = $text; break;
        // レビュー平均
        case '/Response/Body/Ads/Ad/ReviewAverage': $this->ads[$i]['ReviewAverage'] = $text; break;
        // ジャンルID
        case '/Response/Body/Ads/Ad/GenreId': $this->ads[$i]['GenreId'] = $text; break;

        // 上記以外
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 商品情報を取得する
     *
     * @access public
     * @return array 商品情報
     */
    function getAds()
    {
        return $this->ads;
    }

}
