<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAdDynamicTravelResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天ダイナミックアドAPI　トラベル用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天ダイナミックアドAPI　トラベル
 *   http://webservice.rakuten.co.jp/api/dynamicad_travel/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAdDynamicTravelResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceAdDynamicTravelResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 商品情報
     *
     * @access private
     * @var array
     */
    var $ads = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/Response/Body/Ads/Ad': $i++; break;
        // 施設名称
        case '/Response/Body/Ads/Ad/HotelName': $this->ads[$i]['hotelName'] = $text; break;
        // 施設番号
        case '/Response/Body/Ads/Ad/HotelNo': $this->ads[$i]['hotelNo'] = $text; break;
        // 商品価格
        case '/Response/Body/Ads/Ad/ItemPrice': $this->ads[$i]['ItemPrice'] = $text; break;
        // アフィリエイトURL
        case '/Response/Body/Ads/Ad/AffiliateHotelInformationUrl': $this->ads[$i]['AffiliateHotelInformationUrl'] = $text; break;
        // 要約情報（地区）
        case '/Response/Body/Ads/Ad/AreaSum': $this->ads[$i]['AreaSum'] = $text; break;
        // 施設画像（小）
        case '/Response/Body/Ads/Ad/SmallImageUrl': $this->ads[$i]['SmallImageUrl'] = $text; break;
        // 施設画像（中）
        case '/Response/Body/Ads/Ad/MediumImageUrl': $this->ads[$i]['MediumImageUrl'] = $text; break;
        // レビュー数
        case '/Response/Body/Ads/Ad/ReviewCount': $this->ads[$i]['ReviewCount'] = $text; break;
        // レビュー平均
        case '/Response/Body/Ads/Ad/ReviewAverage': $this->ads[$i]['ReviewAverage'] = $text; break;

        // 上記以外
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 商品情報を取得する
     *
     * @access public
     * @return array 商品情報
     */
    function getAds()
    {
        return $this->ads;
    }

}
