<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelHotelDetailSearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天トラベル施設情報API用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天トラベル施設情報API  
 *   http://webservice.rakuten.co.jp/api/hoteldetailsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelHotelDetailSearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceTravelHotelDetailSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 施設情報
     *
     * @access private
     * @var array
     */
    var $hotel = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 施設番号
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelNo': $this->hotel['hotelNo'] = $text; break;
        // 施設名称
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelName': $this->hotel['hotelName'] = $text; break;
        // 郵便番号
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/postalCode': $this->hotel['postalCode'] = $text; break;
        // 住所１
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/address1': $this->hotel['address1'] = $text; break;
        // 住所２
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/address2': $this->hotel['address2'] = $text; break;
        // 施設電話番号
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/telephoneNo': $this->hotel['telephoneNo'] = $text; break;
        // ファックス番号
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/faxNo': $this->hotel['faxNo'] = $text; break;
        // チェックイン時刻
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/checkinTime': $this->hotel['checkinTime'] = $text; break;
        // 最終チェックイン時刻
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/lastCheckinTime': $this->hotel['lastCheckinTime'] = $text; break;
        // チェックアウト時刻
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/checkoutTime': $this->hotel['checkoutTime'] = $text; break;
        // 緯度
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/latitude': $this->hotel['latitude'] = $text; break;
        // 経度
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/longitude': $this->hotel['longitude'] = $text; break;
        // 施設へのアクセス
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/access': $this->hotel['access'] = $text; break;
        // 駐車場情報
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/parkingInformation': $this->hotel['parkingInformation'] = $text; break;
        // 施設特色
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelSpecial': $this->hotel['hotelSpecial'] = $text; break;
        // 部屋設備・備品
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/roomFixture': $this->hotel['roomFixture'] = $text; break;
        // 館内設備
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelFixture': $this->hotel['hotelFixture'] = $text; break;
        // 特典
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/privilege': $this->hotel['privilege'] = $text; break;
        // ポイント加算について
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/aboutPointAdd': $this->hotel['aboutPointAdd'] = $text; break;
        // マイレージ加算について
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/aboutMileageAdd': $this->hotel['aboutMileageAdd'] = $text; break;
        // 食事場所について
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/aboutMealPlace': $this->hotel['aboutMealPlace'] = $text; break;
        // 風呂について
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/aboutBath': $this->hotel['aboutBath'] = $text; break;
        // 使用可能なカード
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/availableCreditCard': $this->hotel['availableCreditCard'] = $text; break;
        // カード利用について
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/aboutCreditCardNote': $this->hotel['aboutCreditCardNote'] = $text; break;
        // 周辺のレジャーについて
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/aboutLeisure': $this->hotel['aboutLeisure'] = $text; break;
        // 条件・注意事項・備考
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/note': $this->hotel['note'] = $text; break;
        // キャンセルポリシー
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/cancelPolicy': $this->hotel['cancelPolicy'] = $text; break;
        // 海外施設の言語レベルについて
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/linguisticLevel': $this->hotel['linguisticLevel'] = $text; break;
        // 身障者設備
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/handicappedFixture': $this->hotel['handicappedFixture'] = $text; break;
        // その他情報
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/otherInformation': $this->hotel['otherInformation'] = $text; break;
        // 施設画像URL
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelImageUrl': $this->hotel['hotelImageUrl'] = $text; break;
        // 部屋画像URL
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/roomImageUrl': $this->hotel['roomImageUrl'] = $text; break;
        // 施設提供地図画像URL
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelMapImageUrl': $this->hotel['hotelMapImageUrl'] = $text; break;
        // 施設情報ページURL
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelInformationUrl': $this->hotel['hotelInformationUrl'] = $text; break;
        // 施設情報ページアフィリエイトURL
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/hotelAffiliateUrl': $this->hotel['hotelAffiliateUrl'] = $text; break;
        // 宿泊予約センター電話番号
        case '/Response/Body/hotelDetailSearch:HotelDetailSearch/reserveTelephoneNo': $this->hotel['reserveTelephoneNo'] = $text; break;

        // 上記以外
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 施設情報を取得する
     *
     * @access public
     * @param string キー名
     * @return mixed 施設情報
     */
    function getHotel($name=null)
    {
        if ($name !== null) {
            return isset($this->hotel[$name]) ? $this->hotel[$name] : null;
        } else {
            return $this->hotel;
        }
    }
}
