<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionSellingListRequest.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - オークション - 出品リスト用）
 */
require_once 'SyL_WebServiceAuctionSellingListResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - オークション - 出品リスト用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * オークション - 出品リスト
 *   http://developer.yahoo.co.jp/auctions/rest/sellinglist/V1/sellinglist.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionSellingListRequest.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceAuctionSellingListRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'auctions.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/AuctionWebService/V1/SellingList';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceAuctionSellingListResponse';

    /**
     * 出品者のYahoo! JAPAN IDをセットする
     *
     * @access public
     * @param string 出品者のYahoo! JAPAN ID
     */
    function setSellerID($sellerID)
    {
        parent::set('sellerID', $sellerID);
    }

    /**
     * 商品リストのページ番号をセットする
     *
     * @access public
     * @param int 商品リストのページ番号
     */
    function setPage($page)
    {
        if (preg_match('/^\d+$/', $page) && ($page > 0)) {
            parent::set('page', $page);
        } else {
            trigger_error("[SyL error] Invalid `page' property ({$page}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 受け取り後決済サービスの利用可能な商品の絞り込み指定をセットする
     *
     * @access public
     * @param int 受け取り後決済サービスの利用可能な商品の絞り込み指定
     */
    function setEscrow($escrow)
    {
        if (preg_match('/^\d+$/', $escrow)) {
            parent::set('escrow', $escrow);
        } else {
            trigger_error("[SyL error] Invalid `escrow' property ({$escrow}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Yahoo!かんたん決済の利用が可能な商品の絞り込み指定をセットする
     *
     * @access public
     * @param int Yahoo!かんたん決済の利用が可能な商品の絞り込み指定
     */
    function setEasypayment($easypayment)
    {
        if (preg_match('/^\d+$/', $easypayment)) {
            parent::set('easypayment', $easypayment);
        } else {
            trigger_error("[SyL error] Invalid `easypayment' property ({$easypayment}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 画像ありの商品の絞り込み指定をセットする
     *
     * @access public
     * @param int 画像ありの商品の絞り込み指定
     */
    function setThumbnail($thumbnail)
    {
        if (preg_match('/^\d+$/', $thumbnail)) {
            parent::set('thumbnail', $thumbnail);
        } else {
            trigger_error("[SyL error] Invalid `thumbnail' property ({$thumbnail}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
