<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategorySearchResponse.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - ディレクトリサーチ用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * ディレクトリサーチ
 *   http://developer.yahoo.co.jp/category/search/V1/search.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceCategorySearchResponse.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceCategorySearchResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * レスポンスの状態やサーバーからのメッセージ
     *
     * @access private
     * @var array
     */
     var $status = array();
    /**
     * カテゴリ属性
     *
     * @access private
     * @var array
     */
    var $category_property = array();
    /**
     * カテゴリの検索結果の集合
     *
     * @access private
     * @var array
     */
    var $category = array();
    /**
     * サイト属性
     *
     * @access private
     * @var int
     */
    var $site_property = array();
    /**
     * 登録サイト検索結果の集合
     *
     * @access private
     * @var array
     */
    var $site = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $item_i = -1;
        static $site_i = -1;

        switch ($current_path) {
        // APIに渡されたパラメータの集合
        case '/ResultSet/Status/Args/Arg': $this->status[$attribute['Name']] = $attribute['Value']; break;

        // =============================
        // エラー系
        // =============================
        // エラー判定
        case '/ResultSet/Status/Errors': $this->error = true; break;
        case '/ResultSet/Status/Errors/Error': $this->error_message .= $text; break;

        // =============================
        // 正常系
        // =============================
        // カテゴリ
        case '/ResultSet/DirSearchResults': $this->category_property = $attribute; break;
        // カテゴリItem
        case '/ResultSet/DirSearchResults/Item': $item_i++; break;

        // カテゴリのID
        case '/ResultSet/DirSearchResults/Item/Id': $this->category[$item_i]['Id'] = $text; break;
        // カテゴリタイプ
        case '/ResultSet/DirSearchResults/Item/Type': $this->category[$item_i]['Type'] = $text; break;
        // カテゴリ名
        case '/ResultSet/DirSearchResults/Item/Title': $this->category[$item_i]['Title'] = $text; break;
        // Yahoo! JAPANが提供するYahoo!カテゴリのページURLから、「http://dir.yahoo.co.jp/」を除いたもの
        case '/ResultSet/DirSearchResults/Item/Path': $this->category[$item_i]['Path'] = $text; break;
        // カテゴリページのURL
        case '/ResultSet/DirSearchResults/Item/Url': $this->category[$item_i]['Url'] = $text; break;
        // カテゴリページへのリンク用（クリック用）URL
        case '/ResultSet/DirSearchResults/Item/ClickUrl': $this->category[$item_i]['ClickUrl'] = $text; break;
        // Yahoo! JAPANが提供するYahoo!カテゴリの、ページの「カテゴリパス（Breadcrumb）」
        case '/ResultSet/DirSearchResults/Item/JPath': $this->category[$item_i]['JPath'] = $text; break;
        // カテゴリが作成された日付
        case '/ResultSet/DirSearchResults/Item/Created': $this->category[$item_i]['Created'] = $text; break;
        // アダルトカテゴリの場合
        case '/ResultSet/DirSearchResults/Item/Adult': $this->category[$item_i]['Adult'] = $text; break;
        // 過去1週間以内に新しく登録されたカテゴリの場合
        case '/ResultSet/DirSearchResults/Item/New': $this->category[$item_i]['New'] = $text; break;

        // 登録サイト
        case '/ResultSet/SiteSearchResults': $this->site_property = $attribute; break;
        // 登録サイトItem
        case '/ResultSet/SiteSearchResults/Item': $site_i++; break;

        // サイトが登録されているカテゴリのID
        case '/ResultSet/SiteSearchResults/Item/Parent': $this->site[$site_i]['Parent'] = $text; break;
        // サイトが登録されているカテゴリのカテゴリ名
        case '/ResultSet/SiteSearchResults/Item/ParentName': $this->site[$site_i]['ParentName'] = $text; break;
        // サイトが登録されているカテゴリページURL
        case '/ResultSet/SiteSearchResults/Item/ParentCategoryUrl': $this->site[$site_i]['ParentCategoryUrl'] = $text; break;
        // サイトが登録されているカテゴリページへのリンク用（クリック用）URL
        case '/ResultSet/SiteSearchResults/Item/ParentCategoryClickUrl': $this->site[$site_i]['ParentCategoryClickUrl'] = $text; break;
        // サイトタイプ
        case '/ResultSet/SiteSearchResults/Item/Type': $this->site[$site_i]['Type'] = $text; break;
        // 登録サイト名
        case '/ResultSet/SiteSearchResults/Item/Title': $this->site[$site_i]['Title'] = $text; break;
        // 登録サイトの説明
        case '/ResultSet/SiteSearchResults/Item/Summary': $this->site[$site_i]['Summary'] = $text; break;
        // 登録サイトのURL
        case '/ResultSet/SiteSearchResults/Item/Url': $this->site[$site_i]['Url'] = $text; break;
        // 登録サイトへのリンク用（クリック用）URL
        case '/ResultSet/SiteSearchResults/Item/ClickUrl': $this->site[$site_i]['ClickUrl'] = $text; break;
        // サイトが登録された日付
        case '/ResultSet/SiteSearchResults/Item/Created': $this->site[$site_i]['Created'] = $text; break;
        // アダルトサイトの場合
        case '/ResultSet/SiteSearchResults/Item/Adult': $this->site[$site_i]['Adult'] = $text; break;
        // 過去1週間以内に新しく登録されたサイトの場合
        case '/ResultSet/SiteSearchResults/Item/New': $this->site[$site_i]['New'] = $text; break;
        // 「新着情報」の「今週のオススメ」に掲載されたサイトの場合
        case '/ResultSet/SiteSearchResults/Item/Picks': $this->site[$site_i]['Picks'] = $text; break;
        // Yahoo!カテゴリ独自の基準によって、優れた内容であると評価されたサイトの場合
        case '/ResultSet/SiteSearchResults/Item/Cool': $this->site[$site_i]['Cool'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * レスポンスの状態やサーバーからのメッセージを取得
     *
     * @access public
     * @param string キー
     * @return mixed レスポンスの状態やサーバーからのメッセージ
     */
    function getStatus($name=null)
    {
        if ($name !== null) {
            return isset($this->status[$name]) ? $this->status[$name] : null;
        } else {
            return $this->status;
        }
    }

    /**
     * カテゴリの検索結果数を取得
     *
     * @access public
     * @return int カテゴリの検索結果数
     */
    function getCategoryCount()
    {
        return isset($this->category_property['Count']) ? $this->category_property['Count'] : 0;
    }

    /**
     * カテゴリの検索結果の総数を取得
     *
     * @access public
     * @return int カテゴリの検索結果の総数
     */
    function getCategoryTotalCount()
    {
        return isset($this->category_property['TotalCount']) ? $this->category_property['TotalCount'] : 0;
    }

    /**
     * 結果の取得開始位置を取得
     *
     * @access public
     * @return int 結果の取得開始位置
     */
    function getCategoryStart()
    {
        return isset($this->category_property['Start']) ? $this->category_property['Start'] : 0;
    }

    /**
     * カテゴリデータを取得する
     *
     * @access public
     * @return array カテゴリデータ配列
     */
    function getCategory()
    {
        return $this->category;
    }

    /**
     * サイトの検索結果数を取得
     *
     * @access public
     * @return int カテゴリの検索結果数
     */
    function getSiteCount()
    {
        return isset($this->site_property['Count']) ? $this->site_property['Count'] : 0;
    }

    /**
     * サイトの検索結果の総数を取得
     *
     * @access public
     * @return int カテゴリの検索結果の総数
     */
    function getSiteTotalCount()
    {
        return isset($this->site_property['TotalCount']) ? $this->site_property['TotalCount'] : 0;
    }

    /**
     * サイトの結果の取得開始位置を取得
     *
     * @access public
     * @return int サイトの結果の取得開始位置
     */
    function getSiteStart()
    {
        return isset($this->site_property['Start']) ? $this->site_property['Start'] : 0;
    }

    /**
     * サイトデータを取得する
     *
     * @access public
     * @return array サイトデータ配列
     */
    function getSite()
    {
        return $this->site;
    }
}
