<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceChiebukuroCategoryTreeResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - Yahoo!知恵袋:カテゴリツリー用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * Yahoo!知恵袋:カテゴリツリー
 *   http://developer.yahoo.co.jp/chiebukuro/categoryTree/V1/categoryTree.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceChiebukuroCategoryTreeResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceChiebukuroCategoryTreeResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * データ内のマッチしたクエリー数
     *
     * @access private
     * @var int 
     */
     var $total_results_available = 0;
    /**
     * 返却され、かつマッチしたクエリーの数
     *
     * @access private
     * @var int 
     */
    var $total_results_returned = 0;
    /**
     * 検索結果データ配列
     *
     * @access private
     * @var array
     */
    var $results = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsAvailable'])) {
                $this->total_results_available = $attribute['totalResultsAvailable'];
            }
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            break;

        // カテゴリ
        case '/ResultSet/Result/Category': $i++; break;
        // カテゴリID
        case '/ResultSet/Result/Category/Id': $this->results[$i]['Id'] = $text; break;
        // カテゴリ名
        case '/ResultSet/Result/Category/Title': $this->results[$i]['Title'] = $text; break;
        // 階層表示したカテゴリID
        case '/ResultSet/Result/Category/IdPath': $this->results[$i]['IdPath'] = $text; break;
        // 階層表示したカテゴリ名
        case '/ResultSet/Result/Category/Path': $this->results[$i]['Path'] = $text; break;

        // =============================
        // エラー系
        // =============================
        // エラー判定
        case '/ResultSet/Status/StatusCode': if($text == '-1'){$this->error = true;} break;
        // エラーメッセージ
        case '/ResultSet/Status/Error/Message': $this->error_message .= '[code: ' . $attribute['code'] . '] ' . $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * データ内のマッチしたクエリー数を取得する
     *
     * @access public
     * @return int データ内のマッチしたクエリー数
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * 返却され、かつマッチしたクエリーの数を取得する
     *
     * @access public
     * @return int 返却され、かつマッチしたクエリーの数
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * 検索結果データを取得する
     *
     * @access public
     * @return array 検索結果データ配列
     */
    function getResults()
    {
        return $this->results;
    }
}
