<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpDAServiceSearchResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - 指定形容詞係り先検索Webサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * 指定形容詞係り先検索Webサービス
 *   http://developer.yahoo.co.jp/jlp/DAServiceSearch/V1/search.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpDAServiceSearchResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceJlpDAServiceSearchResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 指定された形容詞
     *
     * @access private
     * @var int
     */
     var $select_mode = null;
    /**
     * 指定形容詞係り先検索結果
     *
     * @access private
     * @var array
     */
     var $results = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 指定された形容詞
        case '/ResultSet/Result/SelectedMode': $this->select_mode = $text; break;
        // 検索に一致した句の情報
        case '/ResultSet/Result/WordList/Word': $i++; break;
        // 検索に一致した句の表記
        case '/ResultSet/Result/WordList/Word/Surface': $this->results[$i]['Surface'] = $text; break;
        // 検索に一致した句の頻度情報
        case '/ResultSet/Result/WordList/Word/Frequency': $this->results[$i]['Frequency'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * 指定された形容詞を取得
     *
     * @access public
     * @return int 指定された形容詞
     */
    function getSelectMode()
    {
        return $this->select_mode;
    }

    /**
     * 指定形容詞係り先検索結果を取得
     *
     * @access public
     * @return array 指定形容詞係り先検索結果
     */
    function getResults()
    {
        return $this->results;
    }
}
