<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpKouseiServiceRequest.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - 校正支援Webサービス）
 */
require_once 'SyL_WebServiceJlpKouseiServiceResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - 校正支援Webサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * 校正支援Webサービス
 *   http://developer.yahoo.co.jp/jlp/KouseiService/V1/kousei.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceJlpKouseiServiceRequest.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceJlpKouseiServiceRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'jlp.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/KouseiService/V1/kousei';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceJlpKouseiServiceResponse';

    /**
     * 解析対象のテキストをセットする
     *
     * @access public
     * @param string 解析対象のテキスト
     */
    function setSentence($sentence)
    {
        parent::set('sentence', $sentence);
    }

    /**
     * 指摘グループの番号をコンマで区切ってをセットする
     *
     * @access public
     * @param string 指摘グループの番号
     */
    function setFilter_group($filter_group)
    {
        foreach (array_map('trim', explode(',', $filter_group)) as $tmp) {
            switch ($tmp) {
            case '1':
            case '2':
            case '3':
                break;
            default:
                trigger_error("[SyL error] Invalid `filter_group' property ({$filter_group}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('filter_group', $filter_group);
    }

    /**
     * filter_groupで指定した指摘グループから除外する指摘をセットする
     *
     * @access public
     * @param string filter_groupで指定した指摘グループから除外する指摘
     */
    function setNo_filter($no_filter)
    {
        foreach (array_map('trim', explode(',', $no_filter)) as $tmp) {
            if (!is_numeric($tmp) || (($tmp < 1) || ($tmp > 17))) {
                trigger_error("[SyL error] Invalid `no_filter' property ({$no_filter}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('response', $response);
    }
}
