<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertListResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - みんなの検定 検定リストWebサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * みんなの検定 検定リストWebサービス
 *   http://developer.yahoo.co.jp/minna_cert/certlist/V1/certlist.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertListResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMinnaCertCertListResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * データ内のマッチしたクエリー数
     *
     * @access private
     * @var int 
     */
     var $total_results_available = 0;
    /**
     * 返却され、かつマッチしたクエリーの数
     *
     * @access private
     * @var int 
     */
    var $total_results_returned = 0;
    /**
     * 全検索結果の最初のポジション
     *
     * @access private
     * @var int 
     */
    var $first_result_position = 0;
    /**
     * 検索結果データ配列
     *
     * @access private
     * @var array
     */
    var $results = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsAvailable'])) {
                $this->total_results_available = $attribute['totalResultsAvailable'];
            }
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            if (isset($attribute['firstResultPosition'])) {
                $this->first_result_position = $attribute['firstResultPosition'];
            }
            break;
        case '/ResultSet/Result': $i++; break;
        // 検定のID
        case '/ResultSet/Result/CertId': $this->results[$i]['CertId'] = $text; break;
        // 検定名
        case '/ResultSet/Result/CertName': $this->results[$i]['CertName'] = $text; break;
        // 検定区分
        case '/ResultSet/Result/CertDiv': $this->results[$i]['CertDiv'] = $text; break;
        // 検定作成者
        case '/ResultSet/Result/UserName': $this->results[$i]['UserName'] = $text; break;
        // 検定画像のURL
        case '/ResultSet/Result/CertImageUrl': $this->results[$i]['CertImageUrl'] = $text; break;
        // 検定概要
        case '/ResultSet/Result/CertOverview': $this->results[$i]['CertOverview'] = $text; break;
        // 検定の公開日
        case '/ResultSet/Result/OpenDate': $this->results[$i]['OpenDate'] = $text; break;
        // 問題数
        case '/ResultSet/Result/QuestionCount': $this->results[$i]['QuestionCount'] = $text; break;
        // 検定レポート公開フラグ
        case '/ResultSet/Result/ReportOpenFlag': $this->results[$i]['ReportOpenFlag'] = $text; break;
        // 合格基準
        case '/ResultSet/Result/Correct': $this->results[$i]['Correct'] = $text; break;
        // 受験者総数
        case '/ResultSet/Result/ExamAmount': $this->results[$i]['ExamAmount'] = $text; break;
        // 合格者総数
        case '/ResultSet/Result/PassAmount': $this->results[$i]['PassAmount'] = $text; break;
        // お気に入りの検定に登録した利用者の数
        case '/ResultSet/Result/FavoredCertCount': $this->results[$i]['FavoredCertCount'] = $text; break;
        // 投稿されたコメント数
        case '/ResultSet/Result/CommentCount': $this->results[$i]['CommentCount'] = $text; break;
        // 評価ポイントの平均値
        case '/ResultSet/Result/EvalPoint': $this->results[$i]['EvalPoint'] = $text; break;
        // 検定の総合ポイント
        case '/ResultSet/Result/TotalPoint': $this->results[$i]['TotalPoint'] = $text; break;
        // パソコン版の検定詳細ページのURL
        case '/ResultSet/Result/CertDetailPcUrl': $this->results[$i]['CertDetailPcUrl'] = $text; break;
        // モバイル版の検定詳細ページのURL
        case '/ResultSet/Result/CertDetailMbUrl': $this->results[$i]['CertDetailMbUrl'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * データ内のマッチしたクエリー数を取得する
     *
     * @access public
     * @return int データ内のマッチしたクエリー数
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * 返却され、かつマッチしたクエリーの数を取得する
     *
     * @access public
     * @return int 返却され、かつマッチしたクエリーの数
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * 返却され、かつマッチしたクエリーの数を取得する
     *
     * @access public
     * @return int 返却され、かつマッチしたクエリーの数
     */
    function getFirstResultPosition()
    {
        return $this->first_result_position;
    }

    /**
     * 検索結果データを取得する
     *
     * @access public
     * @return array 検索結果データ配列
     */
    function getResults()
    {
        return $this->results;
    }
}
