<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlParser.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 *  XMLパーサークラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlParser.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlParser
{
    /**
     * ファイルパースフラグ
     *
     * @access private
     * @var bool
     */
    var $file_parse_flag = false;
    /**
     * データ or ファイルパス or URL
     *
     * @access private
     * @var string
     */
    var $resource = '';
    /**
     * XML文字コード
     *
     * @access private
     * @var string
     */
    var $xml_encode = 'UTF-8';

    /**
     * コンストラクタ
     *
     * @access public
     */
    function SyL_XmlParser()
    {
    }

    /**
     * XMLデータをセット
     *
     * @access public
     * @param string XMLデータ
     */
    function setData($data)
    {
        $this->resource = $data;
        $this->file_parse_flag = false;
    }

    /**
     * XMLファイルをセット
     *
     * @access public
     * @param string XMLファイル
     */
    function setFile($filename)
    {
        if (!file_exists($filename)) {
            trigger_error("[SyL error] Xml file not found ({$filename})", E_USER_ERROR);
        }
        $this->resource = $filename;
        $this->file_parse_flag = true;
    }

    /**
     * XMLファイルをセット
     *
     * @access public
     * @param string URL
     */
    function setUrl($url)
    {
        $this->resource = $url;
        $this->file_parse_flag = true;
    }

    /**
     * XMLファイルのエンコードをセット
     *
     * @access public
     * @param string エンコード名
     */
    function setXmlEncode($xml_encode)
    {
        $this->xml_encode = $xml_encode;
    }

    /**
     * XMLファイルの解析処理
     *
     * @access public
     */
    function parseXml()
    {
        // XMLパーサー作成 文字コードUTF-8
        $parser = xml_parser_create($this->xml_encode);
        // 大文字変換を行わない
        xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, false);
        // ハンドラメソッドをクラスメソッドに設定
        xml_set_object($parser, $this);
        // start および end 要素のハンドラを設定する
        xml_set_element_handler($parser,
          array(&$this, 'startElement'),
          array(&$this, 'endElement'  )
        );
        // 文字データハンドラを設定する
        xml_set_character_data_handler($parser, array(&$this, 'characters'));
        // デフォルトハンドラを設定する
        xml_set_default_handler($parser, array(&$this, 'defaults'));

        if ($this->file_parse_flag) {
            // XMLファイルオープン
            if (($fp = @fopen($this->resource, 'r')) == false) {
                trigger_error("[SyL error] Can't open xml file({$this->resource})", E_USER_ERROR);
            }
            while (!feof($fp)) {
                // XML解析処理
                $data = fread($fp, 4096);
                $this->parse($parser, $data, feof($fp));
            }
            // XMLファイルクローズ
            fclose($fp);
        } else {
            // XML解析処理
            $this->parse($parser, $this->resource, true);
        }
        // XMLパーサの開放 
        xml_parser_free($parser);
    }

    /**
     * XML解析処理
     *
     * @access private
     * @param resource XMLパーサー
     * @param string XMLデータ
     * @param bool 最後のデータ
     */
    function parse(&$parser, &$data, $eof)
    {
        // XMLパース処理
        if (!xml_parse($parser, $data, $eof)){
            // パースエラー処理
            trigger_error(
              sprintf("[SyL error] XML parse error: %s at %s (%d)",
                xml_error_string(xml_get_error_code($parser)),
                ($this->file_parse_flag ? $this->resource : 'Received DATA'),
                xml_get_current_line_number($parser)
              ),
              E_USER_ERROR
            );
        }
    }

    /**
     * エレメント開始の実行処理
     *
     * @access public
     * @param resource XMLパーサー
     * @param string エレメント名
     * @param array エレメントの属性配列
     */
    function startElement(&$parser, $name, $attr) {}

    /**
     * エレメント終了の実行処理
     *
     * @access public
     * @param resource XMLパーサー
     * @param string エレメント名
     */
    function endElement(&$parser, $name) {}

    /**
     * キャラクタエレメントの実行処理
     *
     * @access public
     * @param resource XMLパーサー
     * @param string 文字列
     */
    function characters(&$parser, $text) {}

    /**
     * デフォルトハンドラ実行処理
     *
     * @access public
     * @param resource XMLパーサー
     * @param string 文字列
     */
    function defaults(&$parser, $data) {}
}
