<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Adm.php,v 1.2 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * DBクラス
 */
SyL_Loader::lib('DB');
/**
 * ファイル処理クラス
 */
SyL_Loader::lib('File');

/**
 * ADM用アクションフォームとDAO用テーブルクラスを作成するクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Adm.php,v 1.2 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class Adm extends AppAction
{
    /**
     * テーブルオブジェクト作成ディレクトリ
     *
     * @access private
     * @var string
     */
    var $table_dir = 'Adm.Tables.';
    /**
     * フォームオブジェクト作成ディレクトリ
     *
     * @access private
     * @var string
     */
    var $form_dir = 'Adm.Forms.';

    /**
     * メイン処理
     *
     * @access public
     * @param object データオブジェクト
     * @param object コンテキストオブジェクト
     */
    function execute(&$data, &$context)
    {
        $cmd =& $context->getConsole();

        $project_dir = $data->geta('d', 0);
        $app_name    = $data->geta('w', 0);
        $action_name = $data->geta('a', 0);
        $controller_dir = dirname($data->geta('c', 0));
        $table_name  = $data->geta('t', 0);
        $smarty_flag = $data->is('s');

        $cmd->stdout("  parameters checking...");

        // -------------------------------------------------
        // プロジェクトディレクトリチェック
        // -------------------------------------------------
        if (!is_dir($project_dir)) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // アプリケーション名チェック
        // -------------------------------------------------
        $app_dir = '';
        if (!$app_name) {
            trigger_error("[SyL error] Application name (-w) not found", E_USER_ERROR);
            exit;
        }
        $app_dir = "{$project_dir}/apps/{$app_name}"; 
        if (!is_dir($app_dir)) {
            trigger_error("[SyL error] Application directory not found ({$app_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // テーブル名チェック
        // -------------------------------------------------
        if (!$table_name) {
            trigger_error("[SyL error] Table name (-t) not found", E_USER_ERROR);
            exit;
        }

        $mkdirs = array();

        // -------------------------------------------------
        // プロジェクトディレクトリチェック
        // -------------------------------------------------
        $cmd->stdout("  project application directory checking...");

        $action_dir   = '';
        $template_dir = '';
        $action_names = array();
        if ($action_name) {
            $action_dir   = "{$app_dir}/actions";
            $template_dir = "{$app_dir}/templates";

            if (substr($action_name, 0, 1) == '/') {
                $action_name = substr($action_name, 1);
            }
            $action_names = array_map('ucfirst', explode('/', $action_name));
            $action_name = implode('/', $action_names);
            if (!is_dir("{$action_dir}/{$action_name}")) {
                if ($cmd->getInput('', "Action directory not found. create directory ? ({$action_dir}/{$action_name}) [Y/n]:") != 'Y') {
                    return;
                }
            }
            if (!is_dir("{$template_dir}/{$action_name}")) {
                if ($cmd->getInput('', "Template directory not found. create directory ? ({$template_dir}/{$action_name}) [Y/n]:") != 'Y') {
                    return;
                }
            }
            foreach ($action_names as $tmp) {
                if ($tmp != '') {
                    $action_dir .= "/{$tmp}";
                    if (file_exists($action_dir)) {
                        if (!is_dir($action_dir)) {
                            trigger_error("[SyL error] Invalid action directory check. already file exist ({$action_dir})", E_USER_ERROR);
                        }
                    } else {
                        $mkdirs[] = $action_dir;
                    }
                    $template_dir .= "/{$tmp}";
                    if (file_exists($template_dir)) {
                        if (!is_dir($template_dir)) {
                            trigger_error("[SyL error] Invalid template directory check. already file exist ({$template_dir})", E_USER_ERROR);
                        }
                    } else {
                        $mkdirs[] = $template_dir;
                    }
                }
            }
        }

        // -------------------------------------------------
        // テーブルディレクトリチェック
        // -------------------------------------------------
        $cmd->stdout("  project lib table directory checking...");

        $table_file  = $project_dir . '/lib';
        $table_class = $this->table_dir . ucfirst($table_name);
        $table_files = explode('/', substr(SyL_Loader::convertPath($table_class), 1));
        $cnt = count($table_files);
        $exist = true;
        for ($i=0; $i<$cnt; $i++) {
            $table_file .= '/' . $table_files[$i];
            if ($i == $cnt - 1) {
                if (file_exists($table_file)) {
                    if ($cmd->getInput('', "Already table file exist. overwrite file ? ({$table_file}) [Y/n]:") != 'Y') {
                        return;
                    }
                    if (!is_writable($table_file)) {
                        trigger_error("[SyL error] Invalid file check. Permission Denied ? ({$table_file})", E_USER_ERROR);
                    }
                }
            } else {
                if (file_exists($table_file)) {
                    if (!is_dir($table_file)) {
                        trigger_error("[SyL error] Invalid directory check. already file exist ({$table_file})", E_USER_ERROR);
                    }
                } else {
                    if ($exist && !is_writable(dirname($table_file))) {
                        trigger_error("[SyL error] Invalid directory check. create permission denied ? ({$table_file})", E_USER_ERROR);
                    }
                    $exist    = false;
                    $mkdirs[] = $table_file;
                }
            }
        }

        // -------------------------------------------------
        // フォームディレクトリチェック
        // -------------------------------------------------
        $cmd->stdout("  project lib form directory checking...");

        $form_file  = $project_dir . '/lib';
        $form_class = $this->form_dir . ucfirst($table_name);
        $form_files = explode('/', substr(SyL_Loader::convertPath($form_class), 1));
        $cnt   = count($form_files);
        $exist = true;
        for ($i=0; $i<$cnt; $i++) {
            $form_file .= '/' . $form_files[$i];
            if ($i == $cnt - 1) {
                if (file_exists($form_file)) {
                    if ($cmd->getInput('', "Already form file exist. overwrite file ? ({$form_file}) [Y/n]:") != 'Y') {
                        return;
                    }
                    if (!is_writable($form_file)) {
                        trigger_error("[SyL error] Unable overwrite. Permission Denied ? ({$form_file})", E_USER_ERROR);
                    }
                }
            } else {
                if (file_exists($form_file)) {
                    if (!is_dir($form_file)) {
                        trigger_error("[SyL error] Unable create directory. Already file exist ({$form_file})", E_USER_ERROR);
                    }
                } else {
                    if ($exist && !is_writable(dirname($form_file))) {
                        trigger_error("[SyL error] Invalid directory check. create permission denied ? ({$form_file})", E_USER_ERROR);
                    }
                    $exist    = false;
                    $mkdirs[] = $form_file;
                }
            }
        }

        // -------------------------------------------------
        // コンテンツ（コントローラ）ディレクトリチェック
        // -------------------------------------------------
        $image_dir = '';
        $css_dir   = '';
        $js_dir    = '';
        if ($controller_dir) {
            $cmd->stdout("  images or css directory checking...");

            $image_dir = "{$controller_dir}/images";
            if (file_exists($image_dir)) {
                if (!is_dir($image_dir)) {
                    trigger_error("[SyL error] Unable create `images' directory. Already file exist ({$image_dir})", E_USER_ERROR);
                }
                if ($cmd->getInput('', "Already `images' directory exist. overwrite directory ? ({$image_dir}) [Y/n]:") != 'Y') {
                    return;
                }
                if (!is_writable($image_dir)) {
                    trigger_error("[SyL error] Invalid `images' directory check. create permission denied ? ({$image_dir})", E_USER_ERROR);
                }
            } else {
                if (!is_writable(dirname($image_dir))) {
                    trigger_error("[SyL error] Invalid `images' directory check. create permission denied ? ({$image_dir})", E_USER_ERROR);
                }
                $mkdirs[] = $image_dir;
            }

            $css_dir = "{$controller_dir}/css";
            if (file_exists($css_dir)) {
                if (!is_dir($css_dir)) {
                    trigger_error("[SyL error] Unable create `css' directory. Already file exist ({$css_dir})", E_USER_ERROR);
                }
                if ($cmd->getInput('', "Already `css' directory exist. overwrite directory ? ({$css_dir}) [Y/n]:") != 'Y') {
                    return;
                }
                if (!is_writable($css_dir)) {
                    trigger_error("[SyL error] Invalid `css' directory check. create permission denied ? ({$css_dir})", E_USER_ERROR);
                }
            } else {
                if (!is_writable(dirname($css_dir))) {
                    trigger_error("[SyL error] Invalid `css' directory check. create permission denied ? ({$css_dir})", E_USER_ERROR);
                }
                $mkdirs[] = $css_dir;
            }

            $js_dir = "{$controller_dir}/js";
            if (file_exists($js_dir)) {
                if (!is_dir($js_dir)) {
                    trigger_error("[SyL error] Unable create `js' directory. Already file exist ({$js_dir})", E_USER_ERROR);
                }
                if ($cmd->getInput('', "Already `js' directory exist. overwrite directory ? ({$js_dir}) [Y/n]:") != 'Y') {
                    return;
                }
                if (!is_writable($js_dir)) {
                    trigger_error("[SyL error] Invalid `js' directory check. create permission denied ? ({$js_dir})", E_USER_ERROR);
                }
            } else {
                if (!is_writable(dirname($js_dir))) {
                    trigger_error("[SyL error] Invalid `js' directory check. create permission denied ? ({$js_dir})", E_USER_ERROR);
                }
                $mkdirs[] = $js_dir;
            }

        }

        // -------------------------------------------------
        // 設定ファイルチェック
        // -------------------------------------------------
        $cmd->stdout("  project or application config checking...");

        $project_config_file = $project_dir . '/config/defines.xml';
        $app_config_file     = $app_dir . '/config/defines.xml';

        if (!is_file($project_config_file)) {
            trigger_error("[SyL error] `defines.xml' not found in project directory({$project_config_file})", E_USER_ERROR);
        }

        // -------------------------------------------------
        // DB接続文字列の取得
        // -------------------------------------------------
        $cmd->stdout("  project or application config `SYL_DB_DSN' getting...");
        $connection_string = $this->getConnectionString($project_config_file, $app_config_file);

        // -------------------------------------------------
        // テーブルスキーマ情報の取得
        // -------------------------------------------------
        $cmd->stdout("  table schema scaning...");
        list($table_columns, $table_primary, $table_uniques, $table_foreigns) = $this->getTableSchema($connection_string, $table_name);

        if (count($table_columns) == 0) {
            trigger_error("[SyL error] Table schema not found ({$table_name})", E_USER_ERROR);
        }

        // 大文字統一
        $table_primary = array_map('strtoupper', $table_primary);
        for ($i=0; $i<count($table_uniques); $i++) {
            $table_uniques[$i] = array_map('strtoupper', $table_uniques[$i]);
        }
        foreach (array_keys($table_foreigns) as $key) {
            $table_foreigns[$key] = array_change_key_case($table_foreigns[$key], CASE_UPPER);
            $table_foreigns[$key] = array_map('strtoupper', $table_foreigns[$key]);
        }

        // -------------------------------------------------
        // ディレクトリ作成
        // -------------------------------------------------
        $cmd->stdout("  create directories...");

        foreach ($mkdirs as $dir) {
            if (!file_exists($dir)) {
                $cmd->stdout("  create directory {$dir}");
                mkdir($dir);
            }
        }

        // -------------------------------------------------
        // ファイル作成
        // -------------------------------------------------
        $cmd->stdout("  create files...");

        // テンプレートファイル
        $template_table_file = SYL_PROJECT_DIR . '/var/templates/Table.php';
        $template_form_file  = SYL_PROJECT_DIR . '/var/templates/Form.php';

        // テーブルファイル作成
        $cmd->stdout("  table template file: {$template_table_file}");

        $cmd->stdout("    -> creating table class...");
        $table_class_source = $this->getTableClassSource($project_dir, $template_table_file, $table_name, $table_class, $table_columns, $table_primary, $table_uniques, $table_foreigns);

        $cmd->stdout("    -> generating table class file... {$table_file}");
        SyL_File::writeContents($table_file, $table_class_source);

        // フォームファイル作成
        $cmd->stdout("  form template file: {$template_form_file}");

        $cmd->stdout("    -> creating form class...");
        $form_class_source = $this->getFormClassSource($project_dir, $template_form_file, $form_class, $table_name, $table_class, $table_columns, $table_primary);

        $cmd->stdout("    -> generating form class file... {$form_file}");
        SyL_File::writeContents($form_file, $form_class_source);

        if ($action_name) {
            // フォーム操作クラス用変換配列初期化
            $form_opp_search  = array();
            $form_opp_replace = array();
            if ($action_name) {
                // プロジェクト名
                $form_opp_search[]  = '{PROJECT_NAME}';
                $form_opp_replace[] = basename($project_dir);
                // アクションディレクトリ
                $form_opp_search[]  = '{ACTION_DIR}';
                $form_opp_replace[] = (count($action_names) > 0) ? implode('_', $action_names) . '_' : '';
                // テンプレートディレクトリ
                $form_opp_search[]  = '{TEMPLATE_DIR}';
                $form_opp_replace[] = (count($action_names) > 0) ? implode('/', $action_names) . '/' : '';
                // フォームクラス名
                $form_opp_search[]  = '{FORM_CLASS_NAME}';
                $form_opp_replace[] = SyL_Loader::convertClass($form_class);
                // フォームクラスパス
                $form_opp_search[]  = '{FORM_CLASS_PATH}';
                $form_opp_replace[] = $form_class;
            }

            // アクションファイル作成
            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/Index.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/Lst.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/New.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/Upd.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/Del.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/Fin.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            $template_file = SYL_PROJECT_DIR . '/var/templates/actions/Vew.php';
            $create_file   = "{$action_dir}/" . basename($template_file);
            $cmd->stdout("  action template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_file)));

            // テンプレートファイル作成
            $dir = ($smarty_flag) ? 'smarty' : 'default';

            $template_file = SYL_PROJECT_DIR . "/var/templates/templates/{$dir}/Lst.html";
            $create_file   = "{$template_dir}/" . basename($template_file);
            $cmd->stdout("  template template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, file_get_contents($template_file));

            $template_file = SYL_PROJECT_DIR . "/var/templates/templates/{$dir}/New.html";
            $create_file   = "{$template_dir}/" . basename($template_file);
            $cmd->stdout("  template template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, file_get_contents($template_file));

            $template_file = SYL_PROJECT_DIR . "/var/templates/templates/{$dir}/Upd.html";
            $create_file   = "{$template_dir}/" . basename($template_file);
            $cmd->stdout("  template template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, file_get_contents($template_file));

            $template_file = SYL_PROJECT_DIR . "/var/templates/templates/{$dir}/Fin.html";
            $create_file   = "{$template_dir}/" . basename($template_file);
            $cmd->stdout("  template template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, file_get_contents($template_file));

            $template_file = SYL_PROJECT_DIR . "/var/templates/templates/{$dir}/Vew.html";
            $create_file   = "{$template_dir}/" . basename($template_file);
            $cmd->stdout("  template template file {$template_file}");
            $cmd->stdout("    -> generating form file {$create_file}");

            SyL_File::writeContents($create_file, file_get_contents($template_file));
        }

        // 画像ファイルコピー
        if ($image_dir) {
            $dir = SYL_PROJECT_DIR . '/var/templates/images';
            if ($dh = opendir($dir)) {
                while (($file = readdir($dh)) !== false) {
                    if (($file != '.') && ($file != '..')) {
                        $cmd->stdout("  copying file {$dir}/{$file}");
                        $cmd->stdout("    -> {$image_dir}/{$file}");
                        copy("{$dir}/{$file}", "{$image_dir}/{$file}");
                    }
                }
                closedir($dh);
            }
        }

        // CSSファイルコピー
        if ($css_dir) {
            $dir = SYL_PROJECT_DIR . '/var/templates/css';
            if ($dh = opendir($dir)) {
                while (($file = readdir($dh)) !== false) {
                    if (($file != '.') && ($file != '..')) {
                        $cmd->stdout("  copying file {$dir}/{$file}");
                        $cmd->stdout("    -> {$css_dir}/{$file}");
                        copy("{$dir}/{$file}", "{$css_dir}/{$file}");
                    }
                }
                closedir($dh);
            }
        }

        // JSファイルコピー
        if ($js_dir) {
            $dir = SYL_PROJECT_DIR . '/var/templates/js';
            if ($dh = opendir($dir)) {
                while (($file = readdir($dh)) !== false) {
                    if (($file != '.') && ($file != '..')) {
                        $cmd->stdout("  copying file {$dir}/{$file}");
                        $cmd->stdout("    -> {$js_dir}/{$file}");
                        copy("{$dir}/{$file}", "{$js_dir}/{$file}");
                    }
                }
                closedir($dh);
            }
        }


        // -------------------------------------------------
        // 結果表示
        // -------------------------------------------------

        $cmd->stdout("");
        $cmd->stdout("--- Result ---");
        $cmd->stdout("  [project directory] {$project_dir}");
        if ($action_name) {
            $cmd->stdout("  [action directory] {$action_dir}");
            $cmd->stdout("  [template directory] {$template_dir}");
        }
        $cmd->stdout("  [table name] {$table_name}");
        $cmd->stdout("  [form class] {$form_file}");
        $cmd->stdout("  [table class] {$table_file}");
        if ($image_dir) {
            $cmd->stdout("  [images directory] {$image_dir}");
        }
        if ($css_dir) {
            $cmd->stdout("  [css directory] {$css_dir}");
        }

        if ($action_name) {
            $action_name = '/' . strtolower($action_name);
            $cmd->stdout("--- URL ---");
            $cmd->stdout("  http://(hostname)/(controller_file){$action_name}/");
        }
    }
}
