<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: CreateController.php,v 1.5 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * コントローラファイル作成コンポーネントクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: CreateController.php,v 1.5 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class CreateController
{
    /**
     * コントローラファイル作成
     *
     * @access public
     * @param object コンソールオブジェクト
     * @param string プロジェクトディレクトリ
     * @param string アプリケーション名
     * @param string コントローラファイル
     */
    function trigger(&$cmd, $project_dir, $app_name, $controller_file)
    {
        if (preg_match('/(\\\\|\/)$/', $project_dir)) {
            $project_dir = substr($project_dir, 0, -1);
        }

        $controller_template = SYL_PROJECT_DIR . '/var/skel-templates/controller.php';
        $contents = file_get_contents($controller_template);

        $trans = array(
          '{{SYL_DIR}}'     => SYL_DIR,
          '{{PROJECT_DIR}}' => $project_dir,
          '{{APP_NAME}}'    => $app_name
        );
        $contents = strtr($contents, $trans);

        $cmd->stdout("  -> creating file {$controller_file}");
        $fp = fopen($controller_file, 'wb');
        fwrite($fp, $contents);
        fclose($fp);
    }
}
