<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL.php,v 1.56 2009/02/14 04:32:56 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * バージョン定義
 */
define('SYL_VERSION', '0.16.1');

/**
 * ベースディレクトリの定義
 */
define('SYL_DIR', dirname(__FILE__));
define('SYL_FRAMEWORK_DIR', SYL_DIR . '/framework');

/**
 * ログ、デバックレベル
 */
define('SYL_LOG_NONE',     0);
define('SYL_LOG_ERROR',    1); // = E_ERROR
define('SYL_LOG_WARN',     2); // = E_WARNING
define('SYL_LOG_NOTICE',   8); // = E_NOTICE
define('SYL_LOG_INFO',  1024); // = E_USER_NOTICE 
define('SYL_LOG_DEBUG', 2047); // = E_ALL

/**
 * エンコード
 */
if (!defined('SYL_ENCODE_INTERNAL')) define('SYL_ENCODE_INTERNAL', 'UTF-8');
if (!defined('SYL_ENCODE_JS'))       define('SYL_ENCODE_JS',       'UTF-8');
if (!defined('SYL_ENCODE_XML'))      define('SYL_ENCODE_XML',      'UTF-8');
if (!defined('SYL_ENCODE_XMLRPC'))   define('SYL_ENCODE_XMLRPC',   'UTF-8');
if (!defined('SYL_ENCODE_MAIL'))     define('SYL_ENCODE_MAIL',     'ISO-2022-JP');

/**
 * タイムゾーン設定（PHP 5.1以上）
 */
if (version_compare(PHP_VERSION, '5.1.0', '>=') && !ini_get('date.timezone')) {
    date_default_timezone_set('Asia/Tokyo');
}

// コントローラ読み込み
require_once SYL_FRAMEWORK_DIR . '/core/SyL_Controller.php';
