<?php
/**
 * バリデーションマネージャロード
 */
SyL_Loader::lib('ValidationManager');

/** 
 * 入力値検証（バリデーション）サンプルクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Index.php,v 1.2 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class Example1_Index extends AppAction
{
    var $prefectures = array(
      '01' => '北海道',
      '02' => '青森県',
      '03' => '岩手県',
      '04' => '宮城県',
      '05' => '秋田県',
      '06' => '山形県',
      '07' => '福島県',
      '08' => '茨城県',
      '09' => '栃木県',
      '10' => '群馬県',
      '11' => '埼玉県',
      '12' => '千葉県',
      '13' => '東京都',
      '14' => '神奈川県',
      '15' => '新潟県',
      '16' => '富山県',
      '17' => '石川県',
      '18' => '福井県',
      '19' => '山梨県',
      '20' => '長野県',
      '21' => '岐阜県',
      '22' => '静岡県',
      '23' => '愛知県',
      '24' => '三重県',
      '25' => '滋賀県',
      '26' => '京都府',
      '27' => '大阪府',
      '28' => '兵庫県',
      '29' => '奈良県',
      '30' => '和歌山県',
      '31' => '鳥取県',
      '32' => '島根県',
      '33' => '岡山県',
      '34' => '広島県',
      '35' => '山口県',
      '36' => '徳島県',
      '37' => '香川県',
      '38' => '愛媛県',
      '39' => '高知県',
      '40' => '福岡県',
      '41' => '佐賀県',
      '42' => '長崎県',
      '43' => '熊本県',
      '44' => '大分県',
      '45' => '宮崎県',
      '46' => '鹿児島県',
      '47' => '沖縄県'
    );

    /**
     * コンストラクタ
     *
     * @access public
     */
    function Example1_Index()
    {
        // アクションの初期処理が記述できます。
    }

    /**
     * アクションメソッド
     *
     * @access public
     * @param object リクエストオブジェクト
     * @param object データ管理オブジェクト
     */
    function execute(&$data, &$context)
    {
        // フォーム値初期化
        $data->set('error_messages', array());
        $data->set('prefectures', $this->prefectures);

        $data->throwInput('lastname');
        $data->throwInput('firstname');
        $data->throwInput('gender');
        $data->throwInput('prefecture');
        $data->throwInput('tel');
        $data->throwInput('mailaddress');
        $data->throwInput('blowser');

        $data->set('valid', false);

        if ($context->isPost()) {
            // 入力した後のポストバック

            // バリデーションマネージャオブジェクト作成
            $validation_manager =& new SyL_ValidationManager();

            // バリデーション基本パターン作成
            $v_require  =& SyL_Validator::create('require', '{name}は必須です');
            $v_numeric  =& SyL_Validator::create('numeric', '{name}は数値で入力してください');
            $v_length6  =& SyL_Validator::create('length',  '{name}は最大{max}文字（バイト）まで入力できます', array('max'=> 6));
            $v_length20 =& SyL_Validator::create('length',  '{name}は最大{max}文字（バイト）まで入力できます', array('max'=> 20));
            $v_email    =& SyL_Validator::create('email',   '{name}の形式が正しくありません');
            $v_regextel =& SyL_Validator::create('regex',   '{name}が正しくありません', array('format'=> '/^[0-9]+\-[0-9]+\-[0-9]{4}$/'));

            // -----------------------------------
            // 検証グループパターン
            // -----------------------------------

            // 入力項目バリデーション用グループ作成し、バリデーション定義を追加
            $vs =& SyL_Validators::create();
            $vs->add($v_require);
            $vs->add($v_length20);
            $validation_manager->add($vs, $data->get('lastname'),  'lastname',  '名前（姓）');
            $validation_manager->add($vs, $data->get('firstname'), 'firstname', '名前（名）');

            $vs =& SyL_Validators::create();
            $vs->add($v_require);
            $validation_manager->add($vs, $data->get('gender'), 'gender', '性別');
            $validation_manager->add($vs, $data->get('prefecture'), 'prefecture', '都道府県');

            $vs =& SyL_Validators::create();
            $vs->add($v_regextel);
            $validation_manager->add($vs, $data->get('tel'), 'tel', '電話番号');

            $vs =& SyL_Validators::create();
            $vs->add($v_require);
            $vs->add($v_email);
            $validation_manager->add($vs, $data->get('mailaddress'), 'mailaddress', 'メールアドレス');

/*
            // -----------------------------------
            // 個別検証パターン
            // -----------------------------------

            // 入力項目に対して、バリデーション基本パターンを実行定義
            $validation_manager->add($v_require,  $data->get('lastname'),  'lastname1', '名前（姓）');
            $validation_manager->add($v_length20, $data->get('lastname'),  'lastname2', '名前（姓）');
            $validation_manager->add($v_require,  $data->get('firstname'), 'firstname1', '名前（名）');
            $validation_manager->add($v_length20, $data->get('firstname'), 'firstname2', '名前（名）');

            $validation_manager->add($v_require, $data->get('gender'), 'gender', '性別');

            $validation_manager->add($v_require, $data->get('prefecture'), 'prefecture', '都道府県');

            $validation_manager->add($v_numeric, $data->get('tel1'), 'tel1',  '電話番号1');
            $validation_manager->add($v_length6, $data->get('tel1'), 'tel11', '電話番号1');
            $validation_manager->add($v_numeric, $data->get('tel2'), 'tel2',  '電話番号2');
            $validation_manager->add($v_length6, $data->get('tel2'), 'tel21', '電話番号2');
            $validation_manager->add($v_numeric, $data->get('tel3'), 'tel3',  '電話番号3');
            $validation_manager->add($v_length6, $data->get('tel3'), 'tel31', '電話番号3');

            $validation_manager->add($v_require,   $data->get('mailaddress'), 'mailaddress1', 'メールアドレス');
            $validation_manager->add($v_email, $data->get('mailaddress'), 'mailaddress2', 'メールアドレス');
*/
            // バリデーション実行
            if ($validation_manager->execute()) {
                $data->set('valid', true);
            } else {
                // エラーの場合、エラーメッセージを取得する
                $data->set('error_messages', $validation_manager->getErrorMessageAll());
            }

        }

        $data->set('script_name', $context->getScriptName());
    }

}

?>
