<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationDel.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 上位レイヤーデータ管理クラス - 削除処理
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_AdmOperationDel.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_AdmOperationDel extends SyL_AdmOperation
{
    /**
     * 削除を行う
     *
     * @access public
     * @return bool true: OK、false: エラー 
     */
    function delete()
    {
        $table = null;
        foreach (array_keys($this->tables) as $alias) {
            if ($alias == $this->form->getMaintenanceTable()) {
                // 削除テーブルオブジェクト取得
                $table =& $this->tables[$alias];
                // 条件オブジェクト作成
                $conditions = $this->dao->createCondition();
                // 主キー条件セット
                $this->setConditionKey($conditions, $alias, true);
                // 条件がセットできない場合は、エラー
                if (count($conditions->gets()) == 0) {
                    return false;
                }
                // 条件オブジェクトセット
                $table->setConditions($conditions);
                break;
            }
        }

        if ($table) {
            return $this->dao->delete($table);
        } else {
            return false;
        }
    }
}
